/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.MappingMultiDocsAndPositionsEnum;
import org.apache.lucene.index.MappingMultiDocsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiDocsAndPositionsEnum;
import org.apache.lucene.index.MultiDocsEnum;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;

class MappedMultiFields
extends FilterAtomicReader.FilterFields {
    final MergeState mergeState;

    public MappedMultiFields(MergeState mergeState, MultiFields multiFields) {
        super(multiFields);
        this.mergeState = mergeState;
    }

    @Override
    public Terms terms(String field) throws IOException {
        MultiTerms terms = (MultiTerms)this.in.terms(field);
        if (terms == null) {
            return null;
        }
        return new MappedMultiTerms(this.mergeState, terms);
    }

    private static class MappedMultiTermsEnum
    extends FilterAtomicReader.FilterTermsEnum {
        final MergeState mergeState;

        public MappedMultiTermsEnum(MergeState mergeState, MultiTermsEnum multiTermsEnum) {
            super(multiTermsEnum);
            this.mergeState = mergeState;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            MappingMultiDocsEnum mappingDocsEnum = reuse instanceof MappingMultiDocsEnum ? (MappingMultiDocsEnum)reuse : new MappingMultiDocsEnum(this.mergeState);
            MultiDocsEnum docsEnum = (MultiDocsEnum)this.in.docs(liveDocs, mappingDocsEnum.multiDocsEnum, flags);
            mappingDocsEnum.reset(docsEnum);
            return mappingDocsEnum;
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            MappingMultiDocsAndPositionsEnum mappingDocsAndPositionsEnum = reuse instanceof MappingMultiDocsAndPositionsEnum ? (MappingMultiDocsAndPositionsEnum)reuse : new MappingMultiDocsAndPositionsEnum(this.mergeState);
            MultiDocsAndPositionsEnum docsAndPositionsEnum = (MultiDocsAndPositionsEnum)this.in.docsAndPositions(liveDocs, mappingDocsAndPositionsEnum.multiDocsAndPositionsEnum, flags);
            mappingDocsAndPositionsEnum.reset(docsAndPositionsEnum);
            return mappingDocsAndPositionsEnum;
        }
    }

    private static class MappedMultiTerms
    extends FilterAtomicReader.FilterTerms {
        final MergeState mergeState;

        public MappedMultiTerms(MergeState mergeState, MultiTerms multiTerms) {
            super(multiTerms);
            this.mergeState = mergeState;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new MappedMultiTermsEnum(this.mergeState, (MultiTermsEnum)this.in.iterator(reuse));
        }

        @Override
        public long size() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

