/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

public final class SegmentReader
extends AtomicReader
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentReader.class) + RamUsageEstimator.shallowSizeOfInstance(SegmentDocValues.class);
    private static final long LONG_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Long.class);
    private final SegmentCommitInfo si;
    private final Bits liveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final CloseableThreadLocal<Map<String, Object>> docValuesLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    final CloseableThreadLocal<Map<String, Bits>> docsWithFieldLocal = new CloseableThreadLocal<Map<String, Bits>>(){

        @Override
        protected Map<String, Bits> initialValue() {
            return new HashMap<String, Bits>();
        }
    };
    final Map<String, DocValuesProducer> dvProducersByField = new HashMap<String, DocValuesProducer>();
    final Set<DocValuesProducer> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final FieldInfos fieldInfos;
    private final List<Long> dvGens = new ArrayList<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentReader(SegmentCommitInfo si, IOContext context) throws IOException {
        this.si = si;
        this.fieldInfos = SegmentReader.readFieldInfos(si);
        this.core = new SegmentCoreReaders(this, si.info.dir, si, context);
        this.segDocValues = new SegmentDocValues();
        boolean success = false;
        Codec codec = si.info.getCodec();
        try {
            if (si.hasDeletions()) {
                this.liveDocs = codec.liveDocsFormat().readLiveDocs(this.directory(), si, IOContext.READONCE);
            } else {
                assert (si.getDelCount() == 0);
                this.liveDocs = null;
            }
            this.numDocs = si.info.getDocCount() - si.getDelCount();
            if (this.fieldInfos.hasDocValues()) {
                this.initDocValuesProducers(codec);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    SegmentReader(SegmentCommitInfo si, SegmentReader sr) throws IOException {
        this(si, sr, si.info.getCodec().liveDocsFormat().readLiveDocs(si.info.dir, si, IOContext.READONCE), si.info.getDocCount() - si.getDelCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentReader(SegmentCommitInfo si, SegmentReader sr, Bits liveDocs, int numDocs) throws IOException {
        this.si = si;
        this.liveDocs = liveDocs;
        this.numDocs = numDocs;
        this.core = sr.core;
        this.core.incRef();
        this.segDocValues = sr.segDocValues;
        boolean success = false;
        try {
            Codec codec = si.info.getCodec();
            this.fieldInfos = si.getFieldInfosGen() == -1L ? sr.fieldInfos : SegmentReader.readFieldInfos(si);
            if (this.fieldInfos.hasDocValues()) {
                this.initDocValuesProducers(codec);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private void initDocValuesProducers(Codec codec) throws IOException {
        Directory dir = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        DocValuesFormat dvFormat = codec.docValuesFormat();
        if (!this.si.hasFieldUpdates()) {
            DocValuesProducer dvp = this.segDocValues.getDocValuesProducer(-1L, this.si, IOContext.READ, dir, dvFormat, this.fieldInfos);
            this.dvGens.add(-1L);
            this.dvProducers.add(dvp);
            for (FieldInfo fi : this.fieldInfos) {
                if (!fi.hasDocValues()) continue;
                assert (fi.getDocValuesGen() == -1L);
                this.dvProducersByField.put(fi.name, dvp);
            }
            return;
        }
        String ver = this.si.info.getVersion();
        if (ver != null && StringHelper.getVersionComparator().compare(ver, "4.9.0") >= 0) {
            DocValuesProducer baseProducer = null;
            for (FieldInfo fieldInfo : this.fieldInfos) {
                if (!fieldInfo.hasDocValues()) continue;
                long docValuesGen = fieldInfo.getDocValuesGen();
                if (docValuesGen == -1L) {
                    if (baseProducer == null) {
                        baseProducer = this.segDocValues.getDocValuesProducer(docValuesGen, this.si, IOContext.READ, dir, dvFormat, this.fieldInfos);
                        this.dvGens.add(docValuesGen);
                        this.dvProducers.add(baseProducer);
                    }
                    this.dvProducersByField.put(fieldInfo.name, baseProducer);
                    continue;
                }
                assert (!this.dvGens.contains(docValuesGen));
                DocValuesProducer dvp = this.segDocValues.getDocValuesProducer(docValuesGen, this.si, IOContext.READ, dir, dvFormat, new FieldInfos(new FieldInfo[]{fieldInfo}));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                this.dvProducersByField.put(fieldInfo.name, dvp);
            }
        } else {
            HashMap<Long, ArrayList<FieldInfo>> genInfos = new HashMap<Long, ArrayList<FieldInfo>>();
            for (FieldInfo fieldInfo : this.fieldInfos) {
                if (!fieldInfo.hasDocValues()) continue;
                ArrayList<FieldInfo> genFieldInfos = (ArrayList<FieldInfo>)genInfos.get(fieldInfo.getDocValuesGen());
                if (genFieldInfos == null) {
                    genFieldInfos = new ArrayList<FieldInfo>();
                    genInfos.put(fieldInfo.getDocValuesGen(), genFieldInfos);
                }
                genFieldInfos.add(fieldInfo);
            }
            for (Map.Entry entry : genInfos.entrySet()) {
                long docValuesGen = (Long)entry.getKey();
                List infos = (List)entry.getValue();
                DocValuesProducer dvp = docValuesGen == -1L ? this.segDocValues.getDocValuesProducer(docValuesGen, this.si, IOContext.READ, dir, dvFormat, this.fieldInfos) : this.segDocValues.getDocValuesProducer(docValuesGen, this.si, IOContext.READ, dir, dvFormat, new FieldInfos(infos.toArray(new FieldInfo[infos.size()])));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                for (FieldInfo fi : infos) {
                    this.dvProducersByField.put(fi.name, dvp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FieldInfos readFieldInfos(SegmentCommitInfo info) throws IOException {
        boolean closeDir;
        Directory dir;
        if (info.getFieldInfosGen() == -1L && info.info.getUseCompoundFile()) {
            dir = new CompoundFileDirectory(info.info.dir, IndexFileNames.segmentFileName(info.info.name, "", "cfs"), IOContext.READONCE, false);
            closeDir = true;
        } else {
            dir = info.info.dir;
            closeDir = false;
        }
        try {
            String segmentSuffix = info.getFieldInfosGen() == -1L ? "" : Long.toString(info.getFieldInfosGen(), 36);
            Codec codec = info.info.getCodec();
            FieldInfosFormat fisFormat = codec.fieldInfosFormat();
            FieldInfos fieldInfos = fisFormat.getFieldInfosReader().read(dir, info.info.name, segmentSuffix, IOContext.READONCE);
            return fieldInfos;
        }
        finally {
            if (closeDir) {
                dir.close();
            }
        }
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        try {
            this.core.decRef();
            this.dvProducersByField.clear();
        }
        catch (Throwable throwable) {
            this.dvProducersByField.clear();
            try {
                IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal);
            }
            finally {
                this.segDocValues.decRef(this.dvGens);
            }
            throw throwable;
        }
        try {
            IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal);
        }
        finally {
            this.segDocValues.decRef(this.dvGens);
        }
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    public StoredFieldsReader getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public Fields fields() {
        this.ensureOpen();
        return this.core.fields;
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.si.info.getDocCount();
    }

    public TermVectorsReader getTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        if (docID < 0 || docID >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + docID + ")");
        }
    }

    public String toString() {
        return this.si.toString(this.si.info.dir, this.si.info.getDocCount() - this.numDocs - this.si.getDelCount());
    }

    public String getSegmentName() {
        return this.si.info.name;
    }

    public SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public Directory directory() {
        return this.si.info.dir;
    }

    @Override
    public Object getCoreCacheKey() {
        return this.core;
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this;
    }

    private FieldInfo getDVField(String field, FieldInfo.DocValuesType type) {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof NumericDocValues) {
            return (NumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducersByField.get(field);
        assert (dvProducer != null);
        NumericDocValues dv = dvProducer.getNumeric(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        Map<String, Bits> dvFields = this.docsWithFieldLocal.get();
        Bits previous = dvFields.get(field);
        if (previous != null) {
            return previous;
        }
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducersByField.get(field);
        assert (dvProducer != null);
        Bits dv = dvProducer.getDocsWithField(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        Map<String, Object> dvFields = this.docValuesLocal.get();
        BinaryDocValues dvs = (BinaryDocValues)dvFields.get(field);
        if (dvs == null) {
            DocValuesProducer dvProducer = this.dvProducersByField.get(field);
            assert (dvProducer != null);
            dvs = dvProducer.getBinary(fi);
            dvFields.put(field, dvs);
        }
        return dvs;
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedDocValues) {
            return (SortedDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducersByField.get(field);
        assert (dvProducer != null);
        SortedDocValues dv = dvProducer.getSorted(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedNumericDocValues) {
            return (SortedNumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducersByField.get(field);
        assert (dvProducer != null);
        SortedNumericDocValues dv = dvProducer.getSortedNumeric(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field);
        if (previous != null && previous instanceof SortedSetDocValues) {
            return (SortedSetDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field, FieldInfo.DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        DocValuesProducer dvProducer = this.dvProducersByField.get(field);
        assert (dvProducer != null);
        SortedSetDocValues dv = dvProducer.getSortedSet(fi);
        dvFields.put(field, dv);
        return dv;
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return this.core.getNormValues(this.fieldInfos, field);
    }

    @Override
    public void addCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.ensureOpen();
        this.core.addCoreClosedListener(listener);
    }

    @Override
    public void removeCoreClosedListener(AtomicReader.CoreClosedListener listener) {
        this.ensureOpen();
        this.core.removeCoreClosedListener(listener);
    }

    @Override
    public long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = BASE_RAM_BYTES_USED;
        ramBytesUsed += (long)this.dvGens.size() * LONG_RAM_BYTES_USED;
        ramBytesUsed += (long)(this.dvProducers.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        ramBytesUsed += (long)(this.dvProducersByField.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (this.dvProducers != null) {
            for (DocValuesProducer producer : this.dvProducers) {
                ramBytesUsed += producer.ramBytesUsed();
            }
        }
        if (this.core != null) {
            ramBytesUsed += this.core.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        this.getFieldsReader().checkIntegrity();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader != null) {
            termVectorsReader.checkIntegrity();
        }
        if (this.core.fields != null) {
            this.core.fields.checkIntegrity();
        }
        if (this.core.normsProducer != null) {
            this.core.normsProducer.checkIntegrity();
        }
        if (this.dvProducers != null) {
            for (DocValuesProducer producer : this.dvProducers) {
                producer.checkIntegrity();
            }
        }
    }
}

