/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.StorableField;
import org.apache.lucene.util.BytesRef;

public class StoredDocument
implements Iterable<StorableField> {
    private final List<StorableField> fields = new ArrayList<StorableField>();
    private static final String[] NO_STRINGS = new String[0];

    public final void add(StorableField field) {
        this.fields.add(field);
    }

    public StorableField[] getFields(String name) {
        ArrayList<StorableField> result = new ArrayList<StorableField>();
        for (StorableField field : this.fields) {
            if (!field.name().equals(name)) continue;
            result.add(field);
        }
        return result.toArray(new StorableField[result.size()]);
    }

    public final StorableField getField(String name) {
        for (StorableField field : this.fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public final List<StorableField> getFields() {
        return this.fields;
    }

    @Override
    public Iterator<StorableField> iterator() {
        return this.fields.iterator();
    }

    public final BytesRef[] getBinaryValues(String name) {
        ArrayList<BytesRef> result = new ArrayList<BytesRef>();
        for (StorableField field : this.fields) {
            BytesRef bytes;
            if (!field.name().equals(name) || (bytes = field.binaryValue()) == null) continue;
            result.add(bytes);
        }
        return result.toArray(new BytesRef[result.size()]);
    }

    public final BytesRef getBinaryValue(String name) {
        for (StorableField field : this.fields) {
            BytesRef bytes;
            if (!field.name().equals(name) || (bytes = field.binaryValue()) == null) continue;
            return bytes;
        }
        return null;
    }

    public final String[] getValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (StorableField field : this.fields) {
            if (!field.name().equals(name) || field.stringValue() == null) continue;
            result.add(field.stringValue());
        }
        if (result.size() == 0) {
            return NO_STRINGS;
        }
        return result.toArray(new String[result.size()]);
    }

    public final String get(String name) {
        for (StorableField field : this.fields) {
            if (!field.name().equals(name) || field.stringValue() == null) continue;
            return field.stringValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("StoredDocument<");
        for (int i = 0; i < this.fields.size(); ++i) {
            StorableField field = this.fields.get(i);
            buffer.append(field.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

