/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AutomatonTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class Terms {
    public static final Terms[] EMPTY_ARRAY = new Terms[0];

    protected Terms() {
    }

    public abstract TermsEnum iterator(TermsEnum var1) throws IOException;

    public TermsEnum intersect(CompiledAutomaton compiled, final BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        if (startTerm == null) {
            return new AutomatonTermsEnum(this.iterator(null), compiled);
        }
        return new AutomatonTermsEnum(this.iterator(null), compiled){

            @Override
            protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
                if (term == null) {
                    term = startTerm;
                }
                return super.nextSeekTerm(term);
            }
        };
    }

    public abstract long size() throws IOException;

    public abstract long getSumTotalTermFreq() throws IOException;

    public abstract long getSumDocFreq() throws IOException;

    public abstract int getDocCount() throws IOException;

    public abstract boolean hasFreqs();

    public abstract boolean hasOffsets();

    public abstract boolean hasPositions();

    public abstract boolean hasPayloads();

    public BytesRef getMin() throws IOException {
        return this.iterator(null).next();
    }

    public BytesRef getMax() throws IOException {
        TermsEnum iterator;
        BytesRef v;
        long size = this.size();
        if (size == 0L) {
            return null;
        }
        if (size >= 0L) {
            try {
                TermsEnum iterator2 = this.iterator(null);
                iterator2.seekExact(size - 1L);
                return iterator2.term();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        if ((v = (iterator = this.iterator(null)).next()) == null) {
            return v;
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.append((byte)0);
        while (true) {
            int low = 0;
            int high = 256;
            while (low != high) {
                int mid = low + high >>> 1;
                scratch.setByteAt(scratch.length() - 1, (byte)mid);
                if (iterator.seekCeil(scratch.get()) == TermsEnum.SeekStatus.END) {
                    if (mid == 0) {
                        scratch.setLength(scratch.length() - 1);
                        return scratch.get();
                    }
                    high = mid;
                    continue;
                }
                if (low == mid) break;
                low = mid;
            }
            scratch.setLength(scratch.length() + 1);
            scratch.grow(scratch.length());
        }
    }
}

