/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.ArrayUtil;

public abstract class CachingCollector
extends FilterCollector {
    private static final int INITIAL_ARRAY_SIZE = 128;
    private boolean cached = true;

    public static CachingCollector create(final boolean acceptDocsOutOfOrder, boolean cacheScores, double maxRAMMB) {
        SimpleCollector other = new SimpleCollector(){

            @Override
            public boolean acceptsDocsOutOfOrder() {
                return acceptDocsOutOfOrder;
            }

            @Override
            public void collect(int doc) {
            }
        };
        return CachingCollector.create((Collector)other, cacheScores, maxRAMMB);
    }

    public static CachingCollector create(Collector other, boolean cacheScores, double maxRAMMB) {
        int bytesPerDoc = 4;
        if (cacheScores) {
            bytesPerDoc += 4;
        }
        int maxDocsToCache = (int)(maxRAMMB * 1024.0 * 1024.0 / (double)bytesPerDoc);
        return CachingCollector.create(other, cacheScores, maxDocsToCache);
    }

    public static CachingCollector create(Collector other, boolean cacheScores, int maxDocsToCache) {
        return cacheScores ? new ScoreCachingCollector(other, maxDocsToCache) : new NoScoreCachingCollector(other, maxDocsToCache);
    }

    private CachingCollector(Collector in) {
        super(in);
    }

    public final boolean isCached() {
        return this.cached;
    }

    public abstract void replay(Collector var1) throws IOException;

    private class ScoreCachingLeafCollector
    extends NoScoreCachingLeafCollector {
        Scorer scorer;
        float[] scores;

        ScoreCachingLeafCollector(LeafCollector in, int maxDocsToCache) {
            super(in, maxDocsToCache);
            this.scores = new float[this.docs.length];
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        protected void grow(int newLen) {
            super.grow(newLen);
            this.scores = Arrays.copyOf(this.scores, newLen);
        }

        @Override
        protected void invalidate() {
            super.invalidate();
            this.scores = null;
        }

        @Override
        protected void buffer(int doc) throws IOException {
            super.buffer(doc);
            this.scores[this.docCount] = this.scorer.score();
        }

        float[] cachedScores() {
            return this.docs == null ? null : Arrays.copyOf(this.scores, this.docCount);
        }
    }

    private class NoScoreCachingLeafCollector
    extends FilterLeafCollector {
        final int maxDocsToCache;
        int[] docs;
        int docCount;

        NoScoreCachingLeafCollector(LeafCollector in, int maxDocsToCache) {
            super(in);
            this.maxDocsToCache = maxDocsToCache;
            this.docs = new int[Math.min(maxDocsToCache, 128)];
            this.docCount = 0;
        }

        protected void grow(int newLen) {
            this.docs = Arrays.copyOf(this.docs, newLen);
        }

        protected void invalidate() {
            this.docs = null;
            this.docCount = -1;
            CachingCollector.this.cached = false;
        }

        protected void buffer(int doc) throws IOException {
            this.docs[this.docCount] = doc;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.docs != null) {
                if (this.docCount >= this.docs.length) {
                    if (this.docCount >= this.maxDocsToCache) {
                        this.invalidate();
                    } else {
                        int newLen = Math.min(ArrayUtil.oversize(this.docCount + 1, 4), this.maxDocsToCache);
                        this.grow(newLen);
                    }
                }
                if (this.docs != null) {
                    this.buffer(doc);
                    ++this.docCount;
                }
            }
            super.collect(doc);
        }

        boolean hasCache() {
            return this.docs != null;
        }

        int[] cachedDocs() {
            return this.docs == null ? null : Arrays.copyOf(this.docs, this.docCount);
        }
    }

    private static class ScoreCachingCollector
    extends NoScoreCachingCollector {
        List<float[]> scores = new ArrayList<float[]>();

        ScoreCachingCollector(Collector in, int maxDocsToCache) {
            super(in, maxDocsToCache);
        }

        @Override
        protected NoScoreCachingLeafCollector wrap(LeafCollector in, int maxDocsToCache) {
            return new ScoreCachingLeafCollector(in, maxDocsToCache);
        }

        @Override
        protected void postCollect(NoScoreCachingLeafCollector collector) {
            ScoreCachingLeafCollector coll = (ScoreCachingLeafCollector)collector;
            super.postCollect(coll);
            this.scores.add(coll.cachedScores());
        }

        @Override
        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs = (int[])this.docs.get(i);
            float[] scores = this.scores.get(i);
            assert (docs.length == scores.length);
            CachedScorer scorer = new CachedScorer();
            collector.setScorer(scorer);
            for (int j = 0; j < docs.length; ++j) {
                scorer.doc = docs[j];
                scorer.score = scores[j];
                collector.collect(scorer.doc);
            }
        }
    }

    private static class NoScoreCachingCollector
    extends CachingCollector {
        List<Boolean> acceptDocsOutOfOrders;
        List<AtomicReaderContext> contexts;
        List<int[]> docs;
        int maxDocsToCache;
        NoScoreCachingLeafCollector lastCollector;

        NoScoreCachingCollector(Collector in, int maxDocsToCache) {
            super(in);
            this.maxDocsToCache = maxDocsToCache;
            this.contexts = new ArrayList<AtomicReaderContext>();
            this.acceptDocsOutOfOrders = new ArrayList<Boolean>();
            this.docs = new ArrayList<int[]>();
        }

        protected NoScoreCachingLeafCollector wrap(LeafCollector in, int maxDocsToCache) {
            return new NoScoreCachingLeafCollector(in, maxDocsToCache);
        }

        @Override
        public LeafCollector getLeafCollector(AtomicReaderContext context) throws IOException {
            this.postCollection();
            LeafCollector in = this.in.getLeafCollector(context);
            if (this.contexts != null) {
                this.contexts.add(context);
                this.acceptDocsOutOfOrders.add(in.acceptsDocsOutOfOrder());
            }
            if (this.maxDocsToCache >= 0) {
                this.lastCollector = this.wrap(in, this.maxDocsToCache);
                return this.lastCollector;
            }
            return in;
        }

        protected void invalidate() {
            this.maxDocsToCache = -1;
            this.contexts = null;
            this.docs = null;
        }

        protected void postCollect(NoScoreCachingLeafCollector collector) {
            int[] docs = collector.cachedDocs();
            this.maxDocsToCache -= docs.length;
            this.docs.add(docs);
        }

        private void postCollection() {
            if (this.lastCollector != null) {
                if (!this.lastCollector.hasCache()) {
                    this.invalidate();
                } else {
                    this.postCollect(this.lastCollector);
                }
                this.lastCollector = null;
            }
        }

        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs;
            for (int doc : docs = this.docs.get(i)) {
                collector.collect(doc);
            }
        }

        @Override
        public void replay(Collector other) throws IOException {
            this.postCollection();
            if (!this.isCached()) {
                throw new IllegalStateException("cannot replay: cache was cleared because too much RAM was required");
            }
            assert (this.docs.size() == this.contexts.size());
            for (int i = 0; i < this.contexts.size(); ++i) {
                AtomicReaderContext context = this.contexts.get(i);
                boolean docsInOrder = this.acceptDocsOutOfOrders.get(i) == false;
                LeafCollector collector = other.getLeafCollector(context);
                if (!collector.acceptsDocsOutOfOrder() && !docsInOrder) {
                    throw new IllegalArgumentException("cannot replay: given collector does not support out-of-order collection, while the wrapped collector does. Therefore cached documents may be out-of-order.");
                }
                this.collect(collector, i);
            }
        }
    }

    private static final class CachedScorer
    extends Scorer {
        int doc;
        float score;

        private CachedScorer() {
            super(null);
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public final int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int docID() {
            return this.doc;
        }

        @Override
        public final int freq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int nextDoc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return 1L;
        }
    }
}

