/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSet;

public abstract class DocValuesDocIdSet
extends DocIdSet {
    protected final int maxDoc;
    protected final Bits acceptDocs;

    public DocValuesDocIdSet(int maxDoc, Bits acceptDocs) {
        this.maxDoc = maxDoc;
        this.acceptDocs = acceptDocs;
    }

    protected abstract boolean matchDoc(int var1);

    @Override
    public final boolean isCacheable() {
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public final Bits bits() {
        return this.acceptDocs == null ? new Bits(){

            @Override
            public boolean get(int docid) {
                return DocValuesDocIdSet.this.matchDoc(docid);
            }

            @Override
            public int length() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        } : new Bits(){

            @Override
            public boolean get(int docid) {
                return DocValuesDocIdSet.this.matchDoc(docid) && DocValuesDocIdSet.this.acceptDocs.get(docid);
            }

            @Override
            public int length() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        };
    }

    @Override
    public final DocIdSetIterator iterator() throws IOException {
        if (this.acceptDocs == null) {
            return new DocIdSetIterator(){
                private int doc = -1;

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public int nextDoc() {
                    do {
                        ++this.doc;
                        if (this.doc < DocValuesDocIdSet.this.maxDoc) continue;
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    } while (!DocValuesDocIdSet.this.matchDoc(this.doc));
                    return this.doc;
                }

                @Override
                public int advance(int target) {
                    this.doc = target;
                    while (this.doc < DocValuesDocIdSet.this.maxDoc) {
                        if (DocValuesDocIdSet.this.matchDoc(this.doc)) {
                            return this.doc;
                        }
                        ++this.doc;
                    }
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }

                @Override
                public long cost() {
                    return DocValuesDocIdSet.this.maxDoc;
                }
            };
        }
        if (this.acceptDocs instanceof FixedBitSet || this.acceptDocs instanceof OpenBitSet) {
            return new FilteredDocIdSetIterator(((DocIdSet)((Object)this.acceptDocs)).iterator()){

                @Override
                protected boolean match(int doc) {
                    return DocValuesDocIdSet.this.matchDoc(doc);
                }
            };
        }
        return new DocIdSetIterator(){
            private int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                do {
                    ++this.doc;
                    if (this.doc < DocValuesDocIdSet.this.maxDoc) continue;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                } while (!DocValuesDocIdSet.this.matchDoc(this.doc) || !DocValuesDocIdSet.this.acceptDocs.get(this.doc));
                return this.doc;
            }

            @Override
            public int advance(int target) {
                this.doc = target;
                while (this.doc < DocValuesDocIdSet.this.maxDoc) {
                    if (DocValuesDocIdSet.this.matchDoc(this.doc) && DocValuesDocIdSet.this.acceptDocs.get(this.doc)) {
                        return this.doc;
                    }
                    ++this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        };
    }
}

