/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocValuesDocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

public class DocValuesTermsFilter
extends Filter {
    private String field;
    private BytesRef[] terms;

    public DocValuesTermsFilter(String field, BytesRef ... terms) {
        this.field = field;
        this.terms = terms;
    }

    public DocValuesTermsFilter(String field, String ... terms) {
        this.field = field;
        this.terms = new BytesRef[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            this.terms[i] = new BytesRef(terms[i]);
        }
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        final SortedDocValues fcsi = DocValues.getSorted(context.reader(), this.field);
        final FixedBitSet bits = new FixedBitSet(fcsi.getValueCount());
        for (int i = 0; i < this.terms.length; ++i) {
            int ord = fcsi.lookupTerm(this.terms[i]);
            if (ord < 0) continue;
            bits.set(ord);
        }
        return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

            @Override
            protected final boolean matchDoc(int doc) {
                int ord = fcsi.getOrd(doc);
                if (ord == -1) {
                    return false;
                }
                return bits.get(ord);
            }
        };
    }
}

