/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;

public class PositiveScoresOnlyCollector
extends FilterCollector {
    public PositiveScoresOnlyCollector(Collector in) {
        super(in);
    }

    @Override
    public LeafCollector getLeafCollector(AtomicReaderContext context) throws IOException {
        return new FilterLeafCollector(super.getLeafCollector(context)){
            private Scorer scorer;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = new ScoreCachingWrappingScorer(scorer);
                this.in.setScorer(this.scorer);
            }

            @Override
            public void collect(int doc) throws IOException {
                if (this.scorer.score() > 0.0f) {
                    this.in.collect(doc);
                }
            }
        };
    }
}

