/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;

public abstract class Directory
implements Closeable {
    public abstract String[] listAll() throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1, IOContext var2) throws IOException;

    public abstract void sync(Collection<String> var1) throws IOException;

    public abstract IndexInput openInput(String var1, IOContext var2) throws IOException;

    public ChecksumIndexInput openChecksumInput(String name, IOContext context) throws IOException {
        return new BufferedChecksumIndexInput(this.openInput(name, context));
    }

    public abstract Lock makeLock(String var1);

    public abstract void clearLock(String var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void setLockFactory(LockFactory var1) throws IOException;

    public abstract LockFactory getLockFactory();

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + " lockFactory=" + this.getLockFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        block9: {
            IndexInput is;
            IndexOutput os;
            block8: {
                os = null;
                is = null;
                boolean success = false;
                try {
                    os = to.createOutput(dest, context);
                    is = this.openInput(src, context);
                    os.copyBytes(is, is.length());
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(os, is);
                    } else {
                        IOUtils.closeWhileHandlingException(os, is);
                        try {
                            to.deleteFile(dest);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                IOUtils.close(os, is);
                break block9;
            }
            IOUtils.closeWhileHandlingException(os, is);
            try {
                to.deleteFile(dest);
            }
            catch (Throwable t) {}
        }
    }

    protected void ensureOpen() throws AlreadyClosedException {
    }
}

