/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public class QueryBuilder {
    private Analyzer analyzer;
    private boolean enablePositionIncrements = true;

    public QueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Query createBooleanQuery(String field, String queryText) {
        return this.createBooleanQuery(field, queryText, BooleanClause.Occur.SHOULD);
    }

    public Query createBooleanQuery(String field, String queryText, BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        return this.createFieldQuery(this.analyzer, operator, field, queryText, false, 0);
    }

    public Query createPhraseQuery(String field, String queryText) {
        return this.createPhraseQuery(field, queryText, 0);
    }

    public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
    }

    public Query createMinShouldMatchQuery(String field, String queryText, float fraction) {
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("fraction should be >= 0 and <= 1");
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field, queryText, BooleanClause.Occur.MUST);
        }
        Query query = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field, queryText, false, 0);
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            bq.setMinimumNumberShouldMatch((int)(fraction * (float)bq.clauses().size()));
        }
        return query;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }

    protected final Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        BytesRef bytes;
        boolean severalTokensAtSamePosition;
        int positionCount;
        int numTokens;
        PositionIncrementAttribute posIncrAtt;
        TermToBytesRefAttribute termAtt;
        CachingTokenFilter buffer;
        block55: {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            buffer = null;
            termAtt = null;
            posIncrAtt = null;
            numTokens = 0;
            positionCount = 0;
            severalTokensAtSamePosition = false;
            boolean hasMoreTokens = false;
            try (TokenStream source = analyzer.tokenStream(field, queryText);){
                source.reset();
                buffer = new CachingTokenFilter(source);
                buffer.reset();
                termAtt = buffer.getAttribute(TermToBytesRefAttribute.class);
                posIncrAtt = buffer.getAttribute(PositionIncrementAttribute.class);
                if (termAtt == null) break block55;
                try {
                    hasMoreTokens = buffer.incrementToken();
                    while (hasMoreTokens) {
                        int positionIncrement;
                        ++numTokens;
                        int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                        if (positionIncrement != 0) {
                            positionCount += positionIncrement;
                        } else {
                            severalTokensAtSamePosition = true;
                        }
                        hasMoreTokens = buffer.incrementToken();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }
        buffer.reset();
        BytesRef bytesRef = bytes = termAtt == null ? null : termAtt.getBytesRef();
        if (numTokens == 0) {
            return null;
        }
        if (numTokens == 1) {
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                termAtt.fillBytesRef();
            }
            catch (IOException e) {
                // empty catch block
            }
            return this.newTermQuery(new Term(field, BytesRef.deepCopyOf(bytes)));
        }
        if (severalTokensAtSamePosition || !quoted) {
            if (positionCount == 1 || !quoted) {
                BooleanQuery q;
                if (positionCount == 1) {
                    q = this.newBooleanQuery(true);
                    for (int i = 0; i < numTokens; ++i) {
                        try {
                            boolean hasNext = buffer.incrementToken();
                            assert (hasNext);
                            termAtt.fillBytesRef();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        Query currentQuery = this.newTermQuery(new Term(field, BytesRef.deepCopyOf(bytes)));
                        q.add(currentQuery, BooleanClause.Occur.SHOULD);
                    }
                    return q;
                }
                q = this.newBooleanQuery(false);
                Query currentQuery = null;
                for (int i = 0; i < numTokens; ++i) {
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        termAtt.fillBytesRef();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (posIncrAtt != null && posIncrAtt.getPositionIncrement() == 0) {
                        if (!(currentQuery instanceof BooleanQuery)) {
                            Query t = currentQuery;
                            currentQuery = this.newBooleanQuery(true);
                            ((BooleanQuery)currentQuery).add(t, BooleanClause.Occur.SHOULD);
                        }
                        ((BooleanQuery)currentQuery).add(this.newTermQuery(new Term(field, BytesRef.deepCopyOf(bytes))), BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    if (currentQuery != null) {
                        q.add(currentQuery, operator);
                    }
                    currentQuery = this.newTermQuery(new Term(field, BytesRef.deepCopyOf(bytes)));
                }
                q.add(currentQuery, operator);
                return q;
            }
            MultiPhraseQuery mpq = this.newMultiPhraseQuery();
            mpq.setSlop(phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    termAtt.fillBytesRef();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[0]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new Term(field, BytesRef.deepCopyOf(bytes)));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[0]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[0]));
            }
            return mpq;
        }
        PhraseQuery pq = this.newPhraseQuery();
        pq.setSlop(phraseSlop);
        int position = -1;
        for (int i = 0; i < numTokens; ++i) {
            int positionIncrement = 1;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                termAtt.fillBytesRef();
                if (posIncrAtt != null) {
                    positionIncrement = posIncrAtt.getPositionIncrement();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.enablePositionIncrements) {
                pq.add(new Term(field, BytesRef.deepCopyOf(bytes)), position += positionIncrement);
                continue;
            }
            pq.add(new Term(field, BytesRef.deepCopyOf(bytes)));
        }
        return pq;
    }

    protected BooleanQuery newBooleanQuery(boolean disableCoord) {
        return new BooleanQuery(disableCoord);
    }

    protected Query newTermQuery(Term term) {
        return new TermQuery(term);
    }

    protected PhraseQuery newPhraseQuery() {
        return new PhraseQuery();
    }

    protected MultiPhraseQuery newMultiPhraseQuery() {
        return new MultiPhraseQuery();
    }
}

