/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.CachingCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupsCollector;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.BlockGroupingCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.function.FunctionAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.function.FunctionAllGroupsCollector;
import org.apache.lucene.search.grouping.function.FunctionFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.function.FunctionSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;

public class GroupingSearch {
    private final String groupField;
    private final ValueSource groupFunction;
    private final Map<?, ?> valueSourceContext;
    private final Filter groupEndDocs;
    private Sort groupSort = Sort.RELEVANCE;
    private Sort sortWithinGroup;
    private int groupDocsOffset;
    private int groupDocsLimit = 1;
    private boolean fillSortFields;
    private boolean includeScores = true;
    private boolean includeMaxScore = true;
    private Double maxCacheRAMMB;
    private Integer maxDocsToCache;
    private boolean cacheScores;
    private boolean allGroups;
    private boolean allGroupHeads;
    private int initialSize = 128;
    private Collection<?> matchingGroups;
    private Bits matchingGroupHeads;

    public GroupingSearch(String groupField) {
        this(groupField, null, null, null);
    }

    public GroupingSearch(ValueSource groupFunction, Map<?, ?> valueSourceContext) {
        this(null, groupFunction, valueSourceContext, null);
    }

    public GroupingSearch(Filter groupEndDocs) {
        this(null, null, null, groupEndDocs);
    }

    private GroupingSearch(String groupField, ValueSource groupFunction, Map<?, ?> valueSourceContext, Filter groupEndDocs) {
        this.groupField = groupField;
        this.groupFunction = groupFunction;
        this.valueSourceContext = valueSourceContext;
        this.groupEndDocs = groupEndDocs;
    }

    public <T> TopGroups<T> search(IndexSearcher searcher, Query query, int groupOffset, int groupLimit) throws IOException {
        return this.search(searcher, null, query, groupOffset, groupLimit);
    }

    public <T> TopGroups<T> search(IndexSearcher searcher, Filter filter, Query query, int groupOffset, int groupLimit) throws IOException {
        if (this.groupField != null || this.groupFunction != null) {
            return this.groupByFieldOrFunction(searcher, filter, query, groupOffset, groupLimit);
        }
        if (this.groupEndDocs != null) {
            return this.groupByDocBlock(searcher, filter, query, groupOffset, groupLimit);
        }
        throw new IllegalStateException("Either groupField, groupFunction or groupEndDocs must be set.");
    }

    protected TopGroups groupByFieldOrFunction(IndexSearcher searcher, Filter filter, Query query, int groupOffset, int groupLimit) throws IOException {
        AbstractFirstPassGroupingCollector firstRound;
        FunctionAllGroupHeadsCollector allGroupHeadsCollector;
        AbstractAllGroupsCollector allGroupsCollector;
        AbstractFirstPassGroupingCollector firstPassCollector;
        int topN = groupOffset + groupLimit;
        if (this.groupFunction != null) {
            firstPassCollector = new FunctionFirstPassGroupingCollector(this.groupFunction, this.valueSourceContext, this.groupSort, topN);
            allGroupsCollector = this.allGroups ? new FunctionAllGroupsCollector(this.groupFunction, this.valueSourceContext) : null;
            allGroupHeadsCollector = this.allGroupHeads ? new FunctionAllGroupHeadsCollector(this.groupFunction, this.valueSourceContext, this.sortWithinGroup) : null;
        } else {
            firstPassCollector = new TermFirstPassGroupingCollector(this.groupField, this.groupSort, topN);
            allGroupsCollector = this.allGroups ? new TermAllGroupsCollector(this.groupField, this.initialSize) : null;
            allGroupHeadsCollector = this.allGroupHeads ? TermAllGroupHeadsCollector.create(this.groupField, this.sortWithinGroup, this.initialSize) : null;
        }
        if (this.allGroupHeads || this.allGroups) {
            ArrayList<SimpleCollector> collectors = new ArrayList<SimpleCollector>();
            collectors.add(firstPassCollector);
            if (this.allGroups) {
                collectors.add(allGroupsCollector);
            }
            if (this.allGroupHeads) {
                collectors.add(allGroupHeadsCollector);
            }
            firstRound = MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()]));
        } else {
            firstRound = firstPassCollector;
        }
        CachingCollector cachedCollector = null;
        if (this.maxCacheRAMMB != null || this.maxDocsToCache != null) {
            cachedCollector = this.maxCacheRAMMB != null ? CachingCollector.create((Collector)firstRound, (boolean)this.cacheScores, (double)this.maxCacheRAMMB) : CachingCollector.create((Collector)firstRound, (boolean)this.cacheScores, (int)this.maxDocsToCache);
            searcher.search(query, filter, (Collector)cachedCollector);
        } else {
            searcher.search(query, filter, (Collector)firstRound);
        }
        this.matchingGroups = this.allGroups ? allGroupsCollector.getGroups() : Collections.emptyList();
        this.matchingGroupHeads = this.allGroupHeads ? allGroupHeadsCollector.retrieveGroupHeads(searcher.getIndexReader().maxDoc()) : new Bits.MatchNoBits(searcher.getIndexReader().maxDoc());
        Collection<SearchGroup<MutableValue>> topSearchGroups = firstPassCollector.getTopGroups(groupOffset, this.fillSortFields);
        if (topSearchGroups == null) {
            return new TopGroups(new SortField[0], new SortField[0], 0, 0, new GroupDocs[0], Float.NaN);
        }
        int topNInsideGroup = this.groupDocsOffset + this.groupDocsLimit;
        AbstractSecondPassGroupingCollector secondPassCollector = this.groupFunction != null ? new FunctionSecondPassGroupingCollector(topSearchGroups, this.groupSort, this.sortWithinGroup, topNInsideGroup, this.includeScores, this.includeMaxScore, this.fillSortFields, this.groupFunction, this.valueSourceContext) : new TermSecondPassGroupingCollector(this.groupField, topSearchGroups, this.groupSort, this.sortWithinGroup, topNInsideGroup, this.includeScores, this.includeMaxScore, this.fillSortFields);
        if (cachedCollector != null && cachedCollector.isCached()) {
            cachedCollector.replay((Collector)secondPassCollector);
        } else {
            searcher.search(query, filter, (Collector)secondPassCollector);
        }
        if (this.allGroups) {
            return new TopGroups(secondPassCollector.getTopGroups(this.groupDocsOffset), this.matchingGroups.size());
        }
        return secondPassCollector.getTopGroups(this.groupDocsOffset);
    }

    protected TopGroups<?> groupByDocBlock(IndexSearcher searcher, Filter filter, Query query, int groupOffset, int groupLimit) throws IOException {
        int topN = groupOffset + groupLimit;
        BlockGroupingCollector c = new BlockGroupingCollector(this.groupSort, topN, this.includeScores, this.groupEndDocs);
        searcher.search(query, filter, (Collector)c);
        int topNInsideGroup = this.groupDocsOffset + this.groupDocsLimit;
        return c.getTopGroups(this.sortWithinGroup, groupOffset, this.groupDocsOffset, topNInsideGroup, this.fillSortFields);
    }

    public GroupingSearch setCachingInMB(double maxCacheRAMMB, boolean cacheScores) {
        this.maxCacheRAMMB = maxCacheRAMMB;
        this.maxDocsToCache = null;
        this.cacheScores = cacheScores;
        return this;
    }

    public GroupingSearch setCaching(int maxDocsToCache, boolean cacheScores) {
        this.maxDocsToCache = maxDocsToCache;
        this.maxCacheRAMMB = null;
        this.cacheScores = cacheScores;
        return this;
    }

    public GroupingSearch disableCaching() {
        this.maxCacheRAMMB = null;
        this.maxDocsToCache = null;
        return this;
    }

    public GroupingSearch setGroupSort(Sort groupSort) {
        this.groupSort = groupSort;
        return this;
    }

    public GroupingSearch setSortWithinGroup(Sort sortWithinGroup) {
        this.sortWithinGroup = sortWithinGroup;
        return this;
    }

    public GroupingSearch setGroupDocsOffset(int groupDocsOffset) {
        this.groupDocsOffset = groupDocsOffset;
        return this;
    }

    public GroupingSearch setGroupDocsLimit(int groupDocsLimit) {
        this.groupDocsLimit = groupDocsLimit;
        return this;
    }

    public GroupingSearch setFillSortFields(boolean fillSortFields) {
        this.fillSortFields = fillSortFields;
        return this;
    }

    public GroupingSearch setIncludeScores(boolean includeScores) {
        this.includeScores = includeScores;
        return this;
    }

    public GroupingSearch setIncludeMaxScore(boolean includeMaxScore) {
        this.includeMaxScore = includeMaxScore;
        return this;
    }

    public GroupingSearch setAllGroups(boolean allGroups) {
        this.allGroups = allGroups;
        return this;
    }

    public <T> Collection<T> getAllMatchingGroups() {
        return this.matchingGroups;
    }

    public GroupingSearch setAllGroupHeads(boolean allGroupHeads) {
        this.allGroupHeads = allGroupHeads;
        return this;
    }

    public Bits getAllGroupHeads() {
        return this.matchingGroupHeads;
    }

    public GroupingSearch setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        return this;
    }
}

