/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

class TermsQuery
extends MultiTermQuery {
    private final BytesRefHash terms;

    TermsQuery(String field, BytesRefHash terms) {
        super(field);
        this.terms = terms;
    }

    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (this.terms.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return new SeekingTermSetTermsEnum(terms.iterator(null), this.terms);
    }

    public String toString(String string) {
        return "TermsQuery{field=" + this.field + '}';
    }

    static class SeekingTermSetTermsEnum
    extends FilteredTermsEnum {
        private final BytesRefHash terms;
        private final int[] ords;
        private final int lastElement;
        private final BytesRef lastTerm;
        private final BytesRef spare = new BytesRef();
        private final Comparator<BytesRef> comparator;
        private BytesRef seekTerm;
        private int upto = 0;

        SeekingTermSetTermsEnum(TermsEnum tenum, BytesRefHash terms) {
            super(tenum);
            this.terms = terms;
            this.lastElement = terms.size() - 1;
            this.comparator = tenum.getComparator();
            this.ords = terms.sort(this.comparator);
            this.lastTerm = terms.get(this.ords[this.lastElement], new BytesRef());
            this.seekTerm = terms.get(this.ords[this.upto], this.spare);
        }

        protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
            BytesRef temp = this.seekTerm;
            this.seekTerm = null;
            return temp;
        }

        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            int cmp;
            if (this.comparator.compare(term, this.lastTerm) > 0) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            BytesRef currentTerm = this.terms.get(this.ords[this.upto], this.spare);
            if (this.comparator.compare(term, currentTerm) == 0) {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            if (this.upto == this.lastElement) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            do {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.NO;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
            } while ((cmp = this.comparator.compare(this.seekTerm, term)) < 0);
            if (cmp == 0) {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }
    }
}

