/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.rangetree.RangeTreeReader;
import org.apache.lucene.rangetree.RangeTreeSortedNumericDocValues;
import org.apache.lucene.rangetree.RangeTreeSortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

class RangeTreeDocValuesProducer
extends DocValuesProducer {
    private final Map<String, RangeTreeReader> treeReaders = new HashMap<String, RangeTreeReader>();
    private final Map<Integer, Long> fieldToIndexFPs = new HashMap<Integer, Long>();
    private final IndexInput datIn;
    private final AtomicLong ramBytesUsed;
    private final int maxDoc;
    private final DocValuesProducer delegate;
    private final boolean merging;

    public RangeTreeDocValuesProducer(DocValuesProducer delegate, SegmentReadState state) throws IOException {
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"ndm");
        ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaFileName, state.context);
        CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"RangeTreeMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        int fieldCount = metaIn.readVInt();
        for (int i = 0; i < fieldCount; ++i) {
            int fieldNumber = metaIn.readVInt();
            long indexFP = metaIn.readVLong();
            this.fieldToIndexFPs.put(fieldNumber, indexFP);
        }
        CodecUtil.checkFooter((ChecksumIndexInput)metaIn);
        metaIn.close();
        String datFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"ndd");
        this.datIn = state.directory.openInput(datFileName, state.context);
        CodecUtil.checkIndexHeader((DataInput)this.datIn, (String)"RangeTreeData", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
        this.maxDoc = state.segmentInfo.maxDoc();
        this.delegate = delegate;
        this.merging = false;
    }

    RangeTreeDocValuesProducer(RangeTreeDocValuesProducer orig) throws IOException {
        assert (Thread.holdsLock((Object)orig));
        this.datIn = orig.datIn.clone();
        this.ramBytesUsed = new AtomicLong(orig.ramBytesUsed.get());
        this.delegate = orig.delegate.getMergeInstance();
        this.fieldToIndexFPs.putAll(orig.fieldToIndexFPs);
        this.treeReaders.putAll(orig.treeReaders);
        this.merging = true;
        this.maxDoc = orig.maxDoc;
    }

    public synchronized SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        RangeTreeReader treeReader = this.treeReaders.get(field.name);
        if (treeReader == null) {
            Long fp = this.fieldToIndexFPs.get(field.number);
            assert (fp != null);
            IndexInput clone = this.datIn.clone();
            clone.seek(fp.longValue());
            treeReader = new RangeTreeReader(clone);
            if (!this.merging) {
                this.treeReaders.put(field.name, treeReader);
                this.ramBytesUsed.addAndGet(treeReader.ramBytesUsed());
            }
        }
        return new RangeTreeSortedNumericDocValues(treeReader, this.delegate.getSortedNumeric(field));
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.datIn, this.delegate});
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.datIn);
    }

    public NumericDocValues getNumeric(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public BinaryDocValues getBinary(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public SortedDocValues getSorted(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public synchronized SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        RangeTreeReader treeReader = this.treeReaders.get(field.name);
        if (treeReader == null) {
            Long fp = this.fieldToIndexFPs.get(field.number);
            assert (fp != null);
            IndexInput clone = this.datIn.clone();
            clone.seek(fp.longValue());
            treeReader = new RangeTreeReader(clone);
            if (!this.merging) {
                this.treeReaders.put(field.name, treeReader);
                this.ramBytesUsed.addAndGet(treeReader.ramBytesUsed());
            }
        }
        return new RangeTreeSortedSetDocValues(treeReader, this.delegate.getSortedSet(field));
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        return this.delegate.getDocsWithField(field);
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        for (Map.Entry<String, RangeTreeReader> ent : this.treeReaders.entrySet()) {
            resources.add(Accountables.namedAccountable((String)("field " + ent.getKey()), (Accountable)ent.getValue()));
        }
        resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.delegate));
        return resources;
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new RangeTreeDocValuesProducer(this);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get() + this.delegate.ramBytesUsed();
    }
}

