/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDReader {
    static final String USER_ITEM_FILE = "userItemFile";
    private static final Logger log = LoggerFactory.getLogger(IDReader.class);
    private static final Pattern SEPARATOR = Pattern.compile("[\t,]");
    private Configuration conf;
    private String usersFile;
    private String itemsFile;
    private String userItemFile;
    private FastIDSet userIds;
    private FastIDSet itemIds;
    private FastIDSet emptySet;
    private Map<Long, FastIDSet> userItemFilter;

    public IDReader(Configuration conf) {
        this.conf = conf;
        this.emptySet = new FastIDSet();
        this.usersFile = conf.get("usersFile");
        this.itemsFile = conf.get("itemsFile");
        this.userItemFile = conf.get(USER_ITEM_FILE);
    }

    public void readIDs() throws IOException, IllegalStateException {
        if (this.isUserItemFileSpecified()) {
            this.readUserItemFilterIfNeeded();
        }
        if (this.isUsersFileSpecified() || this.isUserItemFilterSpecified()) {
            this.readUserIds();
        }
        if (this.isItemsFileSpecified() || this.isUserItemFilterSpecified()) {
            this.readItemIds();
        }
    }

    public FastIDSet getItemsToRecommendForUser(Long userId) {
        if (this.isUserItemFilterSpecified() && this.userItemFilter.containsKey(userId)) {
            return this.userItemFilter.get(userId);
        }
        return this.emptySet;
    }

    private void readUserIds() throws IOException, IllegalStateException {
        if (this.isUsersFileSpecified() && !this.isUserItemFileSpecified()) {
            this.userIds = this.readIDList(this.usersFile);
        } else if (this.isUserItemFileSpecified() && !this.isUsersFileSpecified()) {
            this.readUserItemFilterIfNeeded();
            this.userIds = IDReader.extractAllUserIdsFromUserItemFilter(this.userItemFilter);
        } else {
            if (!this.isUsersFileSpecified() && !this.isUserItemFileSpecified()) {
                throw new IllegalStateException("Neither usersFile nor userItemFile options are specified");
            }
            throw new IllegalStateException("usersFile and userItemFile options cannot be used simultaneously");
        }
    }

    private void readItemIds() throws IOException, IllegalStateException {
        if (this.isItemsFileSpecified() && !this.isUserItemFileSpecified()) {
            this.itemIds = this.readIDList(this.itemsFile);
        } else if (this.isUserItemFileSpecified() && !this.isItemsFileSpecified()) {
            this.readUserItemFilterIfNeeded();
            this.itemIds = this.extractAllItemIdsFromUserItemFilter(this.userItemFilter);
        } else {
            if (!this.isItemsFileSpecified() && !this.isUserItemFileSpecified()) {
                throw new IllegalStateException("Neither itemsFile nor userItemFile options are specified");
            }
            throw new IllegalStateException("itemsFile and userItemFile options cannot be specified simultaneously");
        }
    }

    private void readUserItemFilterIfNeeded() throws IOException {
        if (!this.isUserItemFilterSpecified() && this.isUserItemFileSpecified()) {
            this.userItemFilter = this.readUserItemFilter(this.userItemFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, FastIDSet> readUserItemFilter(String pathString) throws IOException {
        HashMap result = Maps.newHashMap();
        InputStream in = this.openFile(pathString);
        try {
            for (String line : new FileLineIterable(in)) {
                try {
                    String[] tokens = SEPARATOR.split(line.toString());
                    Long userId = Long.parseLong(tokens[0]);
                    Long itemId = Long.parseLong(tokens[1]);
                    this.addUserAndItemIdToUserItemFilter(result, userId, itemId);
                }
                catch (NumberFormatException nfe) {
                    log.warn("userItemFile line ignored: {}", (Object)line);
                }
            }
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
        return result;
    }

    void addUserAndItemIdToUserItemFilter(Map<Long, FastIDSet> filter, Long userId, Long itemId) {
        FastIDSet itemIds;
        if (filter.containsKey(userId)) {
            itemIds = filter.get(userId);
        } else {
            itemIds = new FastIDSet();
            filter.put(userId, itemIds);
        }
        itemIds.add(itemId);
    }

    static FastIDSet extractAllUserIdsFromUserItemFilter(Map<Long, FastIDSet> filter) {
        FastIDSet result = new FastIDSet();
        for (Long userId : filter.keySet()) {
            result.add(userId);
        }
        return result;
    }

    private FastIDSet extractAllItemIdsFromUserItemFilter(Map<Long, FastIDSet> filter) {
        FastIDSet result = new FastIDSet();
        for (FastIDSet itemIds : filter.values()) {
            result.addAll(itemIds);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastIDSet readIDList(String pathString) throws IOException {
        FastIDSet result = null;
        if (pathString != null) {
            result = new FastIDSet();
            InputStream in = this.openFile(pathString);
            try {
                for (String line : new FileLineIterable(in)) {
                    try {
                        result.add(Long.parseLong(line));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("line ignored: {}", (Object)line);
                    }
                }
            }
            finally {
                Closeables.close((Closeable)in, (boolean)true);
            }
        }
        return result;
    }

    private InputStream openFile(String pathString) throws IOException {
        return HadoopUtil.openStream(new Path(pathString), this.conf);
    }

    public boolean isUsersFileSpecified() {
        return this.usersFile != null;
    }

    public boolean isItemsFileSpecified() {
        return this.itemsFile != null;
    }

    public boolean isUserItemFileSpecified() {
        return this.userItemFile != null;
    }

    public boolean isUserItemFilterSpecified() {
        return this.userItemFilter != null;
    }

    public FastIDSet getUserIds() {
        return this.userIds;
    }

    public FastIDSet getItemIds() {
        return this.itemIds;
    }
}

