/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.Vector;

public final class ToVectorAndPrefReducer
extends Reducer<VarIntWritable, VectorOrPrefWritable, VarIntWritable, VectorAndPrefsWritable> {
    private final VectorAndPrefsWritable vectorAndPrefs = new VectorAndPrefsWritable();

    protected void reduce(VarIntWritable key, Iterable<VectorOrPrefWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ArrayList userIDs = Lists.newArrayList();
        ArrayList prefValues = Lists.newArrayList();
        Vector similarityMatrixColumn = null;
        for (VectorOrPrefWritable value : values) {
            if (value.getVector() == null) {
                userIDs.add(value.getUserID());
                prefValues.add(Float.valueOf(value.getValue()));
                continue;
            }
            if (similarityMatrixColumn != null) {
                throw new IllegalStateException("Found two similarity-matrix columns for item index " + key.get());
            }
            similarityMatrixColumn = value.getVector();
        }
        if (similarityMatrixColumn == null) {
            return;
        }
        this.vectorAndPrefs.set(similarityMatrixColumn, userIDs, prefValues);
        context.write((Object)key, (Object)this.vectorAndPrefs);
    }
}

