/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.preparation;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ToItemVectorsMapper
extends Mapper<VarLongWritable, VectorWritable, IntWritable, VectorWritable> {
    private final IntWritable itemID = new IntWritable();
    private final VectorWritable itemVectorWritable = new VectorWritable();

    protected void map(VarLongWritable rowIndex, VectorWritable vectorWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        Vector userRatings = vectorWritable.get();
        int column = TasteHadoopUtils.idToIndex(rowIndex.get());
        this.itemVectorWritable.setWritesLaxPrecision(true);
        RandomAccessSparseVector itemVector = new RandomAccessSparseVector(Integer.MAX_VALUE, 1);
        for (Vector.Element elem : userRatings.nonZeroes()) {
            this.itemID.set(elem.index());
            itemVector.setQuick(column, elem.get());
            this.itemVectorWritable.set((Vector)itemVector);
            ctx.write((Object)this.itemID, (Object)this.itemVectorWritable);
            itemVector.setQuick(elem.index(), 0.0);
        }
    }
}

