/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.mahout.classifier.AbstractVectorClassifier;
import org.apache.mahout.classifier.sgd.DefaultGradient;
import org.apache.mahout.classifier.sgd.Gradient;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class RankingGradient
implements Gradient {
    private static final Gradient BASIC = new DefaultGradient();
    private int window = 10;
    private final List<Deque<Vector>> history = Lists.newArrayList();

    public RankingGradient(int window) {
        this.window = window;
    }

    @Override
    public final Vector apply(String groupKey, int actual, Vector instance, AbstractVectorClassifier classifier) {
        this.addToHistory(actual, instance);
        Deque<Vector> otherSide = this.history.get(1 - actual);
        int n = otherSide.size();
        Vector r = null;
        for (Vector other : otherSide) {
            Vector g = BASIC.apply(groupKey, actual, instance.minus(other), classifier);
            if (r == null) {
                r = g;
                continue;
            }
            r.assign(g, Functions.plusMult((double)(1.0 / (double)n)));
        }
        return r;
    }

    public void addToHistory(int actual, Vector instance) {
        while (this.history.size() <= actual) {
            this.history.add(new ArrayDeque(this.window));
        }
        Deque<Vector> ourSide = this.history.get(actual);
        ourSide.add(instance);
        while (ourSide.size() >= this.window) {
            ourSide.pollFirst();
        }
    }

    public Gradient getBaseGradient() {
        return BASIC;
    }
}

