/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.AbstractClusteringPolicy;
import org.apache.mahout.clustering.kmeans.Kluster;

public class KMeansClusteringPolicy
extends AbstractClusteringPolicy {
    private double convergenceDelta = 0.001;

    public KMeansClusteringPolicy() {
    }

    public KMeansClusteringPolicy(double convergenceDelta) {
        this.convergenceDelta = convergenceDelta;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.convergenceDelta);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.convergenceDelta = in.readDouble();
    }

    @Override
    public void close(ClusterClassifier posterior) {
        boolean allConverged = true;
        for (Cluster cluster : posterior.getModels()) {
            Kluster kluster = (Kluster)cluster;
            boolean converged = kluster.calculateConvergence(this.convergenceDelta);
            allConverged = allConverged && converged;
            cluster.computeParameters();
        }
    }
}

