/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.clustering.iterator.DistanceMeasureCluster;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;

public class Kluster
extends DistanceMeasureCluster {
    private boolean converged;

    public Kluster() {
    }

    public Kluster(Vector center, int clusterId, DistanceMeasure measure) {
        super(center, clusterId, measure);
    }

    public static String formatCluster(Kluster cluster) {
        return cluster.getIdentifier() + ": " + cluster.computeCentroid().asFormatString();
    }

    public String asFormatString() {
        return Kluster.formatCluster(this);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.converged);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.converged = in.readBoolean();
    }

    public String toString() {
        return this.asFormatString(null);
    }

    @Override
    public String getIdentifier() {
        return (this.converged ? "VL-" : "CL-") + this.getId();
    }

    public boolean computeConvergence(DistanceMeasure measure, double convergenceDelta) {
        Vector centroid = this.computeCentroid();
        this.converged = measure.distance(centroid.getLengthSquared(), centroid, this.getCenter()) <= convergenceDelta;
        return this.converged;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    protected void setConverged(boolean converged) {
        this.converged = converged;
    }

    public boolean calculateConvergence(double convergenceDelta) {
        Vector centroid = this.computeCentroid();
        this.converged = this.getMeasure().distance(centroid.getLengthSquared(), centroid, this.getCenter()) <= convergenceDelta;
        return this.converged;
    }
}

