/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.mapreduce;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.ClusteringUtils;
import org.apache.mahout.clustering.streaming.cluster.StreamingKMeans;
import org.apache.mahout.clustering.streaming.mapreduce.CentroidWritable;
import org.apache.mahout.clustering.streaming.mapreduce.StreamingKMeansUtilsMR;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;

public class StreamingKMeansMapper
extends Mapper<Writable, VectorWritable, IntWritable, CentroidWritable> {
    private static final int NUM_ESTIMATE_POINTS = 1000;
    private StreamingKMeans clusterer;
    private int numPoints = 0;
    private boolean estimateDistanceCutoff = false;
    private List<Centroid> estimatePoints;

    public void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        UpdatableSearcher searcher = StreamingKMeansUtilsMR.searcherFromConfiguration(conf);
        int numClusters = conf.getInt("estimatedNumMapClusters", 1);
        double estimatedDistanceCutoff = conf.getFloat("estimatedDistanceCutoff", -1.0f);
        if (estimatedDistanceCutoff == -1.0) {
            this.estimateDistanceCutoff = true;
            this.estimatePoints = Lists.newArrayList();
        }
        this.clusterer = new StreamingKMeans(searcher, numClusters, estimatedDistanceCutoff);
    }

    private void clusterEstimatePoints() {
        this.clusterer.setDistanceCutoff(ClusteringUtils.estimateDistanceCutoff(this.estimatePoints, this.clusterer.getDistanceMeasure()));
        this.clusterer.cluster(this.estimatePoints);
        this.estimateDistanceCutoff = false;
    }

    public void map(Writable key, VectorWritable point, Mapper.Context context) {
        Centroid centroid = new Centroid(this.numPoints++, point.get(), 1.0);
        if (this.estimateDistanceCutoff) {
            if (this.numPoints < 1000) {
                this.estimatePoints.add(centroid);
            } else if (this.numPoints == 1000) {
                this.clusterEstimatePoints();
            }
        } else {
            this.clusterer.cluster(centroid);
        }
    }

    public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.estimateDistanceCutoff) {
            this.clusterEstimatePoints();
        }
        this.clusterer.reindexCentroids();
        for (Centroid centroid : this.clusterer) {
            context.write((Object)new IntWritable(0), (Object)new CentroidWritable(centroid));
        }
    }
}

