/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public final class CopyConstructorIterator<T>
extends ForwardingIterator<T> {
    private final Iterator<T> delegate;
    private Constructor<T> constructor;

    public CopyConstructorIterator(Iterator<? extends T> copyFrom) {
        this.delegate = Iterators.transform(copyFrom, (Function)new Function<T, T>(){

            public T apply(T from) {
                if (CopyConstructorIterator.this.constructor == null) {
                    Class<?> elementClass = from.getClass();
                    try {
                        CopyConstructorIterator.this.constructor = elementClass.getConstructor(elementClass);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    return CopyConstructorIterator.this.constructor.newInstance(from);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    protected Iterator<T> delegate() {
        return this.delegate;
    }
}

