/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.PriorityQueue;

public class LeastKCache<K extends Comparable<? super K>, V> {
    private final int capacity;
    private final Map<K, V> cache;
    private final PriorityQueue<K> queue;

    public LeastKCache(int capacity) {
        this.capacity = capacity;
        this.cache = Maps.newHashMapWithExpectedSize((int)capacity);
        this.queue = new PriorityQueue(capacity + 1, Collections.reverseOrder());
    }

    public final V get(K key) {
        return this.cache.get(key);
    }

    public final void set(K key, V value) {
        if (!this.contains(key)) {
            this.queue.add(key);
        }
        this.cache.put(key, value);
        while (this.queue.size() > this.capacity) {
            Comparable k = (Comparable)this.queue.poll();
            this.cache.remove(k);
        }
    }

    public final boolean contains(K key) {
        return this.cache.containsKey(key);
    }
}

