/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import com.google.common.primitives.Longs;
import java.util.Arrays;

public class Pattern
implements Comparable<Pattern> {
    private static final int DEFAULT_INITIAL_SIZE = 2;
    private static final float GROWTH_RATE = 1.5f;
    private boolean dirty = true;
    private int hashCode;
    private int length;
    private int[] pattern;
    private long support = Long.MAX_VALUE;

    public Pattern() {
        this(2);
    }

    private Pattern(int size) {
        if (size < 2) {
            size = 2;
        }
        this.pattern = new int[size];
        this.dirty = true;
    }

    public final void add(int id, long supportCount) {
        this.dirty = true;
        if (this.length >= this.pattern.length) {
            this.resize();
        }
        this.pattern[this.length++] = id;
        Arrays.sort(this.pattern, 0, this.length);
        this.support = supportCount > this.support ? this.support : supportCount;
    }

    public final int[] getPattern() {
        return this.pattern;
    }

    public final boolean isSubPatternOf(Pattern frequentPattern) {
        int[] otherPattern = frequentPattern.getPattern();
        int otherLength = frequentPattern.length();
        if (this.length() > frequentPattern.length()) {
            return false;
        }
        int i = 0;
        int otherI = 0;
        while (i < this.length && otherI < otherLength) {
            if (otherPattern[otherI] == this.pattern[i]) {
                ++otherI;
                ++i;
                continue;
            }
            if (otherPattern[otherI] < this.pattern[i]) {
                ++otherI;
                continue;
            }
            return false;
        }
        return otherI != otherLength || i == this.length;
    }

    public final int length() {
        return this.length;
    }

    public final long support() {
        return this.support;
    }

    private void resize() {
        int size = (int)(1.5f * (float)this.length);
        if (size < 2) {
            size = 2;
        }
        int[] oldpattern = this.pattern;
        this.pattern = new int[size];
        System.arraycopy(oldpattern, 0, this.pattern, 0, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pattern other = (Pattern)obj;
        return this.length == other.length && this.support == other.support && Arrays.equals(this.pattern, other.pattern);
    }

    public int hashCode() {
        if (!this.dirty) {
            return this.hashCode;
        }
        int result = Arrays.hashCode(this.pattern);
        result = 31 * result + Longs.hashCode((long)this.support);
        this.hashCode = result = 31 * result + this.length;
        return result;
    }

    public final String toString() {
        int[] arr = new int[this.length];
        System.arraycopy(this.pattern, 0, arr, 0, this.length);
        return Arrays.toString(arr) + '-' + this.support;
    }

    @Override
    public int compareTo(Pattern cr2) {
        long support2 = cr2.support();
        int length2 = cr2.length();
        if (this.support == support2) {
            if (this.length < length2) {
                return -1;
            }
            if (this.length > length2) {
                return 1;
            }
            return 0;
        }
        return this.support > support2 ? 1 : -1;
    }
}

