/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.EncodingMapper;
import org.apache.mahout.vectorizer.Vectorizer;
import org.apache.mahout.vectorizer.VectorizerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextEncodingVectorizer
implements Vectorizer {
    private static final Logger log = LoggerFactory.getLogger(SimpleTextEncodingVectorizer.class);

    @Override
    public void createVectors(Path input, Path output, VectorizerConfig config) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = HadoopUtil.prepareJob(input, output, SequenceFileInputFormat.class, EncodingMapper.class, Text.class, VectorWritable.class, SequenceFileOutputFormat.class, config.getConf());
        Configuration conf = job.getConfiguration();
        conf.set("sequential", String.valueOf(config.isSequentialAccess()));
        conf.set("namedVectors", String.valueOf(config.isNamedVectors()));
        conf.set("analyzer", config.getAnalyzerClassName());
        conf.set("encoderFieldName", config.getEncoderName());
        conf.set("encoderClass", config.getEncoderClass());
        conf.set("cardinality", String.valueOf(config.getCardinality()));
        job.setNumReduceTasks(0);
        boolean finished = job.waitForCompletion(true);
        log.info("result of run: {}", (Object)finished);
        if (!finished) {
            throw new IllegalStateException("Job failed!");
        }
    }
}

