/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;

public class CachingStaticWordValueEncoder
extends StaticWordValueEncoder {
    private final int dataSize;
    private OpenIntIntHashMap[] caches;

    public CachingStaticWordValueEncoder(String name, int dataSize) {
        super(name);
        this.dataSize = dataSize;
        this.initCaches();
    }

    private void initCaches() {
        this.caches = new OpenIntIntHashMap[this.getProbes()];
        for (int ii = 0; ii < this.getProbes(); ++ii) {
            this.caches[ii] = new OpenIntIntHashMap();
        }
    }

    protected OpenIntIntHashMap[] getCaches() {
        return this.caches;
    }

    @Override
    public void setProbes(int probes) {
        super.setProbes(probes);
        this.initCaches();
    }

    protected int hashForProbe(String originalForm, int dataSize, String name, int probe) {
        Preconditions.checkArgument((dataSize == this.dataSize ? 1 : 0) != 0, (Object)("dataSize argument [" + dataSize + "] does not match expected dataSize [" + this.dataSize + ']'));
        if (this.caches[probe].containsKey(originalForm.hashCode())) {
            return this.caches[probe].get(originalForm.hashCode());
        }
        int hash = this.hashForProbe(originalForm.getBytes(Charsets.UTF_8), dataSize, name, probe);
        this.caches[probe].put(originalForm.hashCode(), hash);
        return hash;
    }
}

