/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.pruner;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public class PrunedPartialVectorMergeReducer
extends Reducer<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
    private double normPower;
    private boolean logNormalize;

    protected void reduce(WritableComparable<?> key, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector vector = null;
        for (VectorWritable value : values) {
            if (vector == null) {
                vector = value.get().clone();
                continue;
            }
            vector.assign(value.get(), Functions.PLUS);
        }
        if (vector != null && this.normPower != -1.0) {
            vector = this.logNormalize ? vector.logNormalize(this.normPower) : vector.normalize(this.normPower);
        }
        VectorWritable vectorWritable = new VectorWritable(vector);
        context.write(key, (Object)vectorWritable);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.normPower = conf.getFloat("normalization.power", -1.0f);
        this.logNormalize = conf.getBoolean("vector.lognormalize", false);
    }
}

