/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import com.google.common.base.Function;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.math.Vector;

public final class BenchmarkRunner {
    private static final int BUCKET_SIZE = 10000;
    private static final Random R = RandomUtils.getRandom();
    private final long maxTimeUsec;
    private final long leadTimeUsec;

    public BenchmarkRunner(long leadTimeMs, long maxTimeMs) {
        this.maxTimeUsec = TimeUnit.MILLISECONDS.toNanos(maxTimeMs);
        this.leadTimeUsec = TimeUnit.MILLISECONDS.toNanos(leadTimeMs);
    }

    private static int randIndex() {
        return R.nextInt(10000);
    }

    private static boolean randBool() {
        return R.nextBoolean();
    }

    public TimingStatistics benchmark(BenchmarkFn function) {
        TimingStatistics.Call call;
        TimingStatistics stats = new TimingStatistics();
        boolean result = false;
        do {
            int i = R.nextInt(10000);
            call = stats.newCall(this.leadTimeUsec);
            result ^= ((Boolean)function.apply(i)).booleanValue();
        } while (!call.end(this.maxTimeUsec));
        return stats;
    }

    public TimingStatistics benchmarkD(BenchmarkFnD function) {
        TimingStatistics.Call call;
        TimingStatistics stats = new TimingStatistics();
        double result = 0.0;
        do {
            int i = R.nextInt(10000);
            call = stats.newCall(this.leadTimeUsec);
            result += ((Double)function.apply(i)).doubleValue();
        } while (!call.end(this.maxTimeUsec));
        System.err.println("Result = " + result);
        return stats;
    }

    public static abstract class BenchmarkFnD
    implements Function<Integer, Double> {
        protected int randIndex() {
            return BenchmarkRunner.randIndex();
        }

        protected boolean randBool() {
            return BenchmarkRunner.randBool();
        }

        protected boolean depends(Vector v) {
            return this.randIndex() < v.getNumNondefaultElements();
        }
    }

    public static abstract class BenchmarkFn
    implements Function<Integer, Boolean> {
        protected int randIndex() {
            return BenchmarkRunner.randIndex();
        }

        protected boolean randBool() {
            return BenchmarkRunner.randBool();
        }

        protected boolean depends(Vector v) {
            return this.randIndex() < v.getNumNondefaultElements();
        }
    }
}

