/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.MurmurHash;
import org.junit.Assert;
import org.junit.Test;

public class MurmurHashTest
extends MahoutTestCase {
    @Test
    public void testForLotsOfChange64() throws UnsupportedEncodingException {
        long h1 = MurmurHash.hash64A((byte[])"abc".getBytes(Charsets.UTF_8), (int)0);
        long h2 = MurmurHash.hash64A((byte[])"abc ".getBytes(Charsets.UTF_8), (int)0);
        int flipCount = Long.bitCount(h1 ^ h2);
        Assert.assertTrue((String)("Small changes should result in lots of bit flips, only found " + flipCount), (flipCount > 25 ? 1 : 0) != 0);
    }

    @Test
    public void testHash64() {
        Assert.assertEquals((long)-7148968302806999301L, (long)MurmurHash.hash64A((byte[])"abc".getBytes(Charsets.UTF_8), (int)0));
        Assert.assertEquals((long)-3258132553591018531L, (long)MurmurHash.hash64A((byte[])"abc def ghi jkl ".getBytes(Charsets.UTF_8), (int)0));
        Assert.assertEquals((long)-3659305164543091524L, (long)MurmurHash.hash64A((byte[])"abc def ghi jkl moreGoo".getBytes(Charsets.UTF_8), (int)0));
    }

    @Test
    public void testForLotsOfChange32() throws UnsupportedEncodingException {
        int h1 = MurmurHash.hash((byte[])"abc".getBytes(Charsets.UTF_8), (int)0);
        int h2 = MurmurHash.hash((byte[])"abc ".getBytes(Charsets.UTF_8), (int)0);
        int flipCount = Integer.bitCount(h1 ^ h2);
        Assert.assertTrue((String)("Small changes should result in lots of bit flips, only found " + flipCount), (flipCount > 14 ? 1 : 0) != 0);
    }

    @Test
    public void testChangingSeed() {
        byte[] key = new byte[]{78, -29, -111, 0, 16, -113, -1};
        int[] expected = new int[]{-285688270, -2130059578, -1699790446, -1044599012, -2112017180, -731983393, 1812158375, 567601221, -90711216, 790201800, 1567193130, 225332101, -405155989, 863923017, -513775292, -859731224};
        for (int i = 0; i < expected.length; ++i) {
            int expectedHash = expected[i];
            int hash = MurmurHash.hash((byte[])key, (int)i);
            Assert.assertEquals((String)("i = " + i), (long)expectedHash, (long)hash);
        }
    }

    @Test
    public void testChangingKey() {
        byte[] key = new byte[133];
        int[] expected = new int[]{-683430389, -239836730, -1537577749, -619323389, -2022235740, -1023121935, -77231196, 450859954, -469075663, 1034235312, -1085131503, 519762547, -433536547, -1711061793, -1877173764, 1524738628};
        for (int i = 0; i < 16; ++i) {
            MurmurHashTest.setKey(key, i);
            int expectedHash = expected[i];
            int hash = MurmurHash.hash((byte[])key, (int)305441741);
            Assert.assertEquals((String)("i = " + i), (long)expectedHash, (long)hash);
        }
    }

    @Test
    public void testChangingKeyLength() {
        int[] expected = new int[]{-1597558898, 700643710, 13274042, -2009565066, -503067063, 1490508114, -1417347394, -1743438747, -877427851, 1856086667, -1694855339, -74903882, -1793668023, 1678289131, -1156394010, 16479513};
        for (int i = 0; i < 16; ++i) {
            byte[] key = new byte[i];
            MurmurHashTest.setKey(key, i);
            int expectedHash = expected[i];
            int hash = MurmurHash.hash((byte[])key, (int)2020649727);
            Assert.assertEquals((String)("i = " + i), (long)expectedHash, (long)hash);
        }
    }

    private static void setKey(byte[] key, int start) {
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)(start + i & 0xFF);
        }
    }
}

