/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixTest;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.function.Functions;
import org.junit.Test;

public final class TestSparseMatrix
extends MatrixTest {
    @Override
    public Matrix matrixFactory(double[][] values) {
        SparseMatrix matrix = new SparseMatrix(values.length, values[0].length);
        for (int row = 0; row < matrix.rowSize(); ++row) {
            for (int col = 0; col < matrix.columnSize(); ++col) {
                matrix.setQuick(row, col, values[row][col]);
            }
        }
        return matrix;
    }

    @Test
    public void add() {
        SparseMatrix a = new SparseMatrix(3, 3);
        a.set(0, 0, 1.0);
        a.set(0, 2, 3.0);
        a.set(2, 0, 1.0);
        a.set(2, 1, 2.0);
        SparseMatrix b = new SparseMatrix(3, 3);
        b.set(0, 0, 3.0);
        b.set(0, 2, 1.0);
        b.set(1, 1, 5.0);
        b.set(2, 2, 2.0);
        a.assign((Matrix)b, Functions.PLUS);
        TestSparseMatrix.assertEquals((double)4.0, (double)a.getQuick(0, 0), (double)0.0);
        TestSparseMatrix.assertEquals((double)0.0, (double)a.getQuick(0, 1), (double)0.0);
        TestSparseMatrix.assertEquals((double)4.0, (double)a.getQuick(0, 2), (double)0.0);
        TestSparseMatrix.assertEquals((double)0.0, (double)a.getQuick(1, 0), (double)0.0);
        TestSparseMatrix.assertEquals((double)5.0, (double)a.getQuick(1, 1), (double)0.0);
        TestSparseMatrix.assertEquals((double)0.0, (double)a.getQuick(1, 2), (double)0.0);
        TestSparseMatrix.assertEquals((double)1.0, (double)a.getQuick(2, 0), (double)0.0);
        TestSparseMatrix.assertEquals((double)2.0, (double)a.getQuick(2, 1), (double)0.0);
        TestSparseMatrix.assertEquals((double)2.0, (double)a.getQuick(2, 2), (double)0.0);
    }

    @Test
    public void testSparseCopy() {
        SparseMatrix matrix = this.createSparseMatrixWithEmptyRow();
        Matrix copy = matrix.clone();
        TestSparseMatrix.assertSame((String)"wrong class", copy.getClass(), matrix.getClass());
        SparseMatrix castedCopy = (SparseMatrix)copy;
        Iterator originalSlices = matrix.iterator();
        Iterator copySlices = castedCopy.iterator();
        while (originalSlices.hasNext() && copySlices.hasNext()) {
            MatrixSlice originalSlice = (MatrixSlice)originalSlices.next();
            MatrixSlice copySlice = (MatrixSlice)copySlices.next();
            TestSparseMatrix.assertEquals((String)"Wrong row indices.", (long)originalSlice.index(), (long)copySlice.index());
            TestSparseMatrix.assertEquals((String)"Slices are not equal.", (Object)originalSlice, (Object)copySlice);
        }
        TestSparseMatrix.assertSame((String)"Number of rows of original and copy are not equal.", (Object)originalSlices.hasNext(), (Object)copySlices.hasNext());
    }

    private SparseMatrix createSparseMatrixWithEmptyRow() {
        SparseMatrix result = new SparseMatrix(3, 3);
        result.setQuick(0, 0, 1.0);
        result.setQuick(1, 1, 1.0);
        result.setQuick(1, 2, 1.0);
        return result;
    }
}

