/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixTest;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.jet.random.Gamma;
import org.junit.Assert;
import org.junit.Test;

public final class TestSparseRowMatrix
extends MatrixTest {
    @Override
    public Matrix matrixFactory(double[][] values) {
        SparseRowMatrix matrix = new SparseRowMatrix(values.length, values[0].length);
        for (int row = 0; row < matrix.rowSize(); ++row) {
            for (int col = 0; col < matrix.columnSize(); ++col) {
                matrix.setQuick(row, col, values[row][col]);
            }
        }
        return matrix;
    }

    @Test(timeout=50000L)
    public void testTimesSparseEfficiency() {
        int j;
        RandomWrapper raw = RandomUtils.getRandom();
        Gamma gen = new Gamma(0.1, 0.1, (Random)raw);
        SparseRowMatrix x = new SparseRowMatrix(1000, 2000, false);
        for (int i = 0; i < 1000; ++i) {
            int[] values = new int[1000];
            for (int k = 0; k < 1000; ++k) {
                int n = j = (int)Math.min(1000.0, gen.nextDouble());
                values[n] = values[n] + 1;
            }
            for (int j2 = 0; j2 < 1000; ++j2) {
                if (values[j2] <= 0) continue;
                x.set(i, j2, (double)values[j2]);
            }
        }
        SparseRowMatrix y = new SparseRowMatrix(2000, 1000, false);
        for (int i = 0; i < 2000; ++i) {
            int[] values = new int[1000];
            for (int k = 0; k < 1000; ++k) {
                int j3;
                int n = j3 = (int)Math.min(1000.0, gen.nextDouble());
                values[n] = values[n] + 1;
            }
            for (j = 0; j < 1000; ++j) {
                if (values[j] <= 0) continue;
                y.set(i, j, (double)values[j]);
            }
        }
        long t0 = System.nanoTime();
        Matrix z = x.times((Matrix)y);
        double elapsedTime = (double)(System.nanoTime() - t0) * 1.0E-6;
        System.out.printf("done in %.1f ms\n", elapsedTime);
        for (int k = 0; k < 1000; ++k) {
            int i = (int)(-10.0 * Math.log(raw.nextDouble()));
            int j4 = (int)(-10.0 * Math.log(raw.nextDouble()));
            Assert.assertEquals((double)x.viewRow(i).dot(y.viewColumn(j4)), (double)z.get(i, j4), (double)1.0E-12);
        }
    }

    @Test(timeout=50000L)
    public void testTimesDenseEfficiency() {
        int j;
        RandomWrapper raw = RandomUtils.getRandom();
        Gamma gen = new Gamma(0.1, 0.1, (Random)raw);
        SparseRowMatrix x = new SparseRowMatrix(1000, 2000, false);
        for (int i = 0; i < 1000; ++i) {
            int[] values = new int[1000];
            for (int k = 0; k < 1000; ++k) {
                int j2;
                int n = j2 = (int)Math.min(1000.0, gen.nextDouble());
                values[n] = values[n] + 1;
            }
            for (j = 0; j < 1000; ++j) {
                if (values[j] <= 0) continue;
                x.set(i, j, (double)values[j]);
            }
        }
        DenseMatrix y = new DenseMatrix(2000, 20);
        for (int i = 0; i < 2000; ++i) {
            for (j = 0; j < 20; ++j) {
                y.set(i, j, raw.nextDouble());
            }
        }
        long t0 = System.nanoTime();
        Matrix z = x.times((Matrix)y);
        double elapsedTime = (double)(System.nanoTime() - t0) * 1.0E-6;
        System.out.printf("done in %.1f ms\n", elapsedTime);
        for (int i = 0; i < 1000; ++i) {
            for (int j3 = 0; j3 < 20; ++j3) {
                Assert.assertEquals((double)x.viewRow(i).dot(y.viewColumn(j3)), (double)z.get(i, j3), (double)1.0E-12);
            }
        }
    }

    @Test(timeout=50000L)
    public void testTimesOtherSparseEfficiency() {
        RandomWrapper raw = RandomUtils.getRandom();
        Gamma gen = new Gamma(0.1, 0.1, (Random)raw);
        SparseRowMatrix x = new SparseRowMatrix(1000, 2000, false);
        for (int i = 0; i < 1000; ++i) {
            int[] values = new int[1000];
            for (int k = 0; k < 1000; ++k) {
                int j;
                int n = j = (int)Math.min(1000.0, gen.nextDouble());
                values[n] = values[n] + 1;
            }
            for (int j = 0; j < 1000; ++j) {
                if (values[j] <= 0) continue;
                x.set(i, j, (double)values[j]);
            }
        }
        Vector d = new DenseVector(2000).assign(Functions.random());
        DiagonalMatrix y = new DiagonalMatrix(d);
        long t0 = System.nanoTime();
        Matrix z = x.times((Matrix)y);
        double elapsedTime = (double)(System.nanoTime() - t0) * 1.0E-6;
        System.out.printf("done in %.1f ms\n", elapsedTime);
        for (MatrixSlice row : z) {
            for (Vector.Element element : row.nonZeroes()) {
                TestSparseRowMatrix.assertEquals((double)(x.get(row.index(), element.index()) * d.get(element.index())), (double)element.get(), (double)1.0E-12);
            }
        }
    }

    @Test(timeout=50000L)
    public void testTimesCorrect() {
        RandomWrapper raw = RandomUtils.getRandom();
        Matrix x = new SparseRowMatrix(100, 2000, false).assign(Functions.random());
        Matrix y = new SparseRowMatrix(2000, 100, false).assign(Functions.random());
        Matrix xd = new DenseMatrix(100, 2000).assign(x);
        Matrix yd = new DenseMatrix(2000, 100).assign(y);
        TestSparseRowMatrix.assertEquals((double)0.0, (double)xd.times(yd).minus(x.times(y)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-15);
        TestSparseRowMatrix.assertEquals((double)0.0, (double)x.times(yd).minus(x.times(y)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-15);
        TestSparseRowMatrix.assertEquals((double)0.0, (double)xd.times(y).minus(x.times(y)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-15);
    }
}

