/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.hebbian;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.AsyncEigenVerifier;
import org.apache.mahout.math.decomposer.SingularVectorVerifier;
import org.apache.mahout.math.decomposer.SolverTest;
import org.apache.mahout.math.decomposer.hebbian.EigenUpdater;
import org.apache.mahout.math.decomposer.hebbian.HebbianSolver;
import org.apache.mahout.math.decomposer.hebbian.HebbianUpdater;
import org.apache.mahout.math.decomposer.hebbian.TrainingState;
import org.junit.Test;

public final class TestHebbianSolver
extends SolverTest {
    public static long timeSolver(Matrix corpus, double convergence, int maxNumPasses, TrainingState state) {
        return TestHebbianSolver.timeSolver(corpus, convergence, maxNumPasses, 10, state);
    }

    public static long timeSolver(Matrix corpus, double convergence, int maxNumPasses, int desiredRank, TrainingState state) {
        HebbianUpdater updater = new HebbianUpdater();
        AsyncEigenVerifier verifier = new AsyncEigenVerifier();
        HebbianSolver solver = new HebbianSolver((EigenUpdater)updater, (SingularVectorVerifier)verifier, convergence, maxNumPasses);
        long start = System.nanoTime();
        TrainingState finalState = solver.solve(corpus, desiredRank);
        TestHebbianSolver.assertNotNull((Object)finalState);
        state.setCurrentEigens(finalState.getCurrentEigens());
        state.setCurrentEigenValues(finalState.getCurrentEigenValues());
        long time = 0L;
        verifier.close();
        TestHebbianSolver.assertEquals((long)state.getCurrentEigens().numRows(), (long)desiredRank);
        return (time += System.nanoTime() - start) / 1000000L;
    }

    public static long timeSolver(Matrix corpus, TrainingState state) {
        return TestHebbianSolver.timeSolver(corpus, state, 10);
    }

    public static long timeSolver(Matrix corpus, TrainingState state, int rank) {
        return TestHebbianSolver.timeSolver(corpus, 0.01, 20, rank, state);
    }

    @Test
    public void testHebbianSolver() {
        int numColumns = 800;
        Matrix corpus = TestHebbianSolver.randomSequentialAccessSparseMatrix(1000, 900, numColumns, 30, 1.0);
        int rank = 50;
        DenseMatrix eigens = new DenseMatrix(rank, numColumns);
        TrainingState state = new TrainingState((Matrix)eigens, null);
        long optimizedTime = TestHebbianSolver.timeSolver(corpus, 1.0E-5, 5, rank, state);
        eigens = state.getCurrentEigens();
        TestHebbianSolver.assertEigen((Matrix)eigens, (VectorIterable)corpus, 0.05, false);
        TestHebbianSolver.assertOrthonormal((Matrix)eigens, 1.0E-6);
        System.out.println("Avg solving (Hebbian) time in ms: " + optimizedTime);
    }
}

