/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.RombergIntegrator;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.junit.Assert;

public final class DistributionChecks {
    private DistributionChecks() {
    }

    public static void checkDistribution(final AbstractContinousDistribution dist, double[] x, double offset, double scale, int n) {
        double[] xs = Arrays.copyOf(x, x.length);
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = xs[i] * scale + offset;
        }
        Arrays.sort(xs);
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = dist.nextDouble();
        }
        Arrays.sort(y);
        double[] p = new double[xs.length + 1];
        double lastP = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            double thisP = dist.cdf(xs[i]);
            p[i] = thisP - lastP;
            lastP = thisP;
        }
        p[p.length - 1] = 1.0 - lastP;
        int[] k = new int[xs.length + 1];
        int lastJ = 0;
        for (int i = 0; i < k.length - 1; ++i) {
            int j;
            for (j = 0; j < n && y[j] < xs[i]; ++j) {
            }
            k[i] = j - lastJ;
            lastJ = j;
        }
        k[k.length - 1] = n - lastJ;
        RombergIntegrator integrator = new RombergIntegrator();
        for (int i = 0; i < xs.length - 1; ++i) {
            double delta = integrator.integrate(1000000, new UnivariateFunction(){

                public double value(double v) {
                    return dist.pdf(v);
                }
            }, xs[i], xs[i + 1]);
            Assert.assertEquals((double)delta, (double)p[i + 1], (double)1.0E-6);
        }
        double sum = 0.0;
        for (int i = 0; i < k.length; ++i) {
            if (k[i] == 0) continue;
            sum += (double)k[i] * Math.log((double)k[i] / p[i] / (double)n);
        }
        int dof = k.length - 1;
        double z = Math.sqrt(2.0 * (sum *= 2.0)) - Math.sqrt(2 * dof - 1);
        Assert.assertTrue((String)String.format("offset=%.3f scale=%.3f Z = %.1f", offset, scale, z), (Math.abs(z) < 3.0 ? 1 : 0) != 0);
    }

    static void checkCdf(double offset, double scale, AbstractContinousDistribution dist, double[] breaks, double[] quantiles) {
        int i = 0;
        for (double x : breaks) {
            Assert.assertEquals((String)String.format("m=%.3f sd=%.3f x=%.3f", offset, scale, x), (double)quantiles[i], (double)dist.cdf(x * scale + offset), (double)1.0E-6);
            ++i;
        }
    }
}

