/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.AbstractByteList;
import org.apache.mahout.math.list.ByteArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ByteArrayListTest
extends Assert {
    private ByteArrayList emptyList;
    private ByteArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new ByteArrayList();
        this.listOfFive = new ByteArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((byte)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, (byte)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, (byte)0);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add((byte)12);
        ByteArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((byte)(x % 127));
        }
        ByteArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        ByteArrayListTest.assertEquals((long)12L, (long)this.emptyList.get(0));
        for (x = 0; x < 1000; ++x) {
            ByteArrayListTest.assertEquals((long)((byte)(x % 127)), (long)this.emptyList.get(x + 1));
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo((byte)0, 2, 4);
        ByteArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo((byte)1, 0, 4);
        ByteArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        ByteArrayList l2 = this.listOfFive.copy();
        ByteArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        ByteArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        byte[] l = new byte[]{12, 24, 36, 48};
        ByteArrayList lar = new ByteArrayList(l);
        ByteArrayListTest.assertEquals((long)4L, (long)lar.size());
        ByteArrayListTest.assertSame((Object)l, (Object)lar.elements());
        byte[] l2 = new byte[]{3, 6, 9, 12};
        lar.elements(l2);
        ByteArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        byte[] l = new byte[]{12, 24, 36, 48};
        ByteArrayList lar = new ByteArrayList(l);
        ByteArrayList lar2 = new ByteArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        ByteArrayListTest.assertEquals((Object)lar, (Object)lar2);
        ByteArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add((byte)55);
        ByteArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new ByteProcedure(){
            int count;

            public boolean apply(byte element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1;
            }
        });
    }

    @Test
    public void testGetQuick() {
        ByteArrayList lar = new ByteArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo((byte)0, 2, 4);
        ByteArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo((byte)1, 0, 4);
        ByteArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        ByteArrayList lar = new ByteArrayList(10);
        lar.add((byte)1);
        lar.add((byte)2);
        lar.add((byte)3);
        lar.add((byte)2);
        lar.add((byte)1);
        ByteArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf((byte)2));
        ByteArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo((byte)2, 2, 4));
        ByteArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf((byte)111));
    }

    @Test
    public void testPartFromTo() {
        AbstractByteList al = this.listOfFive.partFromTo(1, 2);
        ByteArrayListTest.assertEquals((long)2L, (long)al.size());
        ByteArrayListTest.assertEquals((long)1L, (long)al.get(0));
        ByteArrayListTest.assertEquals((long)2L, (long)al.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        ByteArrayList lar = new ByteArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((byte)x2);
        }
        ByteArrayList larOdd = new ByteArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((byte)x);
        }
        lar.removeAll((AbstractByteList)larOdd);
        ByteArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            ByteArrayListTest.assertEquals((long)(x * 2), (long)lar.get(x));
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add((byte)5);
        ByteArrayList lar = new ByteArrayList();
        lar.add((byte)44);
        lar.add((byte)55);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractByteList)lar, 0, 1);
        ByteArrayListTest.assertEquals((long)0L, (long)this.listOfFive.get(0));
        ByteArrayListTest.assertEquals((long)1L, (long)this.listOfFive.get(1));
        ByteArrayListTest.assertEquals((long)44L, (long)this.listOfFive.get(2));
        ByteArrayListTest.assertEquals((long)55L, (long)this.listOfFive.get(3));
        ByteArrayListTest.assertEquals((long)4L, (long)this.listOfFive.get(4));
        ByteArrayListTest.assertEquals((long)5L, (long)this.listOfFive.get(5));
    }

    @Test
    public void testRetainAllSmall() {
        ByteArrayList lar = new ByteArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        ByteArrayList lar2 = new ByteArrayList();
        lar2.add((byte)3);
        lar2.add((byte)4);
        ByteArrayListTest.assertTrue((boolean)lar.retainAll((AbstractByteList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            byte l = lar.get(x);
            ByteArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
        ByteArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        ByteArrayList lar = new ByteArrayList();
        lar.addAllOf(this.listOfFive);
        ByteArrayList lar2 = new ByteArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add((byte)3);
            lar2.add((byte)4);
        }
        ByteArrayListTest.assertTrue((boolean)lar.retainAll((AbstractByteList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            byte l = lar.get(x);
            ByteArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
    }
}

