/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.AbstractLongList;
import org.apache.mahout.math.list.LongArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongArrayListTest
extends Assert {
    private LongArrayList emptyList;
    private LongArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new LongArrayList();
        this.listOfFive = new LongArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((long)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, 1L);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, 0L);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add(12L);
        LongArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((long)x % Long.MAX_VALUE);
        }
        LongArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        LongArrayListTest.assertEquals((long)12L, (long)this.emptyList.get(0));
        for (x = 0; x < 1000; ++x) {
            LongArrayListTest.assertEquals((long)((long)x % Long.MAX_VALUE), (long)this.emptyList.get(x + 1));
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo(0L, 2, 4);
        LongArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo(1L, 0, 4);
        LongArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        LongArrayList l2 = this.listOfFive.copy();
        LongArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        LongArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        long[] l = new long[]{12L, 24L, 36L, 48L};
        LongArrayList lar = new LongArrayList(l);
        LongArrayListTest.assertEquals((long)4L, (long)lar.size());
        LongArrayListTest.assertSame((Object)l, (Object)lar.elements());
        long[] l2 = new long[]{3L, 6L, 9L, 12L};
        lar.elements(l2);
        LongArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        long[] l = new long[]{12L, 24L, 36L, 48L};
        LongArrayList lar = new LongArrayList(l);
        LongArrayList lar2 = new LongArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        LongArrayListTest.assertEquals((Object)lar, (Object)lar2);
        LongArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add(55L);
        LongArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new LongProcedure(){
            int count;

            public boolean apply(long element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1L;
            }
        });
    }

    @Test
    public void testGetQuick() {
        LongArrayList lar = new LongArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo(0L, 2, 4);
        LongArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo(1L, 0, 4);
        LongArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        LongArrayList lar = new LongArrayList(10);
        lar.add(1L);
        lar.add(2L);
        lar.add(3L);
        lar.add(2L);
        lar.add(1L);
        LongArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf(2L));
        LongArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo(2L, 2, 4));
        LongArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf(111L));
    }

    @Test
    public void testPartFromTo() {
        AbstractLongList al = this.listOfFive.partFromTo(1, 2);
        LongArrayListTest.assertEquals((long)2L, (long)al.size());
        LongArrayListTest.assertEquals((long)1L, (long)al.get(0));
        LongArrayListTest.assertEquals((long)2L, (long)al.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        LongArrayList lar = new LongArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((long)x2);
        }
        LongArrayList larOdd = new LongArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((long)x);
        }
        lar.removeAll((AbstractLongList)larOdd);
        LongArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            LongArrayListTest.assertEquals((long)(x * 2), (long)lar.get(x));
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add(5L);
        LongArrayList lar = new LongArrayList();
        lar.add(44L);
        lar.add(55L);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractLongList)lar, 0, 1);
        LongArrayListTest.assertEquals((long)0L, (long)this.listOfFive.get(0));
        LongArrayListTest.assertEquals((long)1L, (long)this.listOfFive.get(1));
        LongArrayListTest.assertEquals((long)44L, (long)this.listOfFive.get(2));
        LongArrayListTest.assertEquals((long)55L, (long)this.listOfFive.get(3));
        LongArrayListTest.assertEquals((long)4L, (long)this.listOfFive.get(4));
        LongArrayListTest.assertEquals((long)5L, (long)this.listOfFive.get(5));
    }

    @Test
    public void testRetainAllSmall() {
        LongArrayList lar = new LongArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        LongArrayList lar2 = new LongArrayList();
        lar2.add(3L);
        lar2.add(4L);
        LongArrayListTest.assertTrue((boolean)lar.retainAll((AbstractLongList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            long l = lar.get(x);
            LongArrayListTest.assertTrue((l == 3L || l == 4L ? 1 : 0) != 0);
        }
        LongArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        LongArrayList lar = new LongArrayList();
        lar.addAllOf(this.listOfFive);
        LongArrayList lar2 = new LongArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add(3L);
            lar2.add(4L);
        }
        LongArrayListTest.assertTrue((boolean)lar.retainAll((AbstractLongList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            long l = lar.get(x);
            LongArrayListTest.assertTrue((l == 3L || l == 4L ? 1 : 0) != 0);
        }
    }
}

