/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.function.ByteShortProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenByteShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        OpenByteShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteShortHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        OpenByteShortHashMap map2 = (OpenByteShortHashMap)map.clone();
        map.clear();
        OpenByteShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        OpenByteShortHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteShortHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        OpenByteShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenByteShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteShortHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        map.forEachPair(new ByteShortProcedure(){

            public boolean apply(byte first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenByteShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenByteShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ByteShortProcedure(){
            int count = 0;

            public boolean apply(byte first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        OpenByteShortHashMapTest.assertEquals((long)22L, (long)map.get((byte)11));
        OpenByteShortHashMapTest.assertEquals((long)0L, (long)map.get((byte)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.adjustOrPutValue((byte)11, (short)1, (short)3);
        OpenByteShortHashMapTest.assertEquals((long)25L, (long)map.get((byte)11));
        map.adjustOrPutValue((byte)15, (short)1, (short)3);
        OpenByteShortHashMapTest.assertEquals((long)1L, (long)map.get((byte)15));
    }

    @Test
    public void testKeys() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)22);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteShortProcedure(){

            public boolean apply(byte first, short second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteShortHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteShortHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenByteShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenByteShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenByteShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenByteShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        OpenByteShortHashMap map2 = (OpenByteShortHashMap)map.copy();
        map.clear();
        OpenByteShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        OpenByteShortHashMap map2 = (OpenByteShortHashMap)map.copy();
        OpenByteShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)22);
        map.put((byte)12, (short)23);
        map.put((byte)13, (short)24);
        map.put((byte)14, (short)25);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteShortHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteShortHashMap map = new OpenByteShortHashMap();
        map.put((byte)11, (short)100);
        map.put((byte)12, (short)70);
        map.put((byte)13, (short)30);
        map.put((byte)14, (short)3);
        ByteArrayList keys = new ByteArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenByteShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenByteShortHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenByteShortHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteShortHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenByteShortHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenByteShortHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenByteShortHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        short v;

        Pair(byte k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

