/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharDoubleProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenCharDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        OpenCharDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharDoubleHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        OpenCharDoubleHashMap map2 = (OpenCharDoubleHashMap)map.clone();
        map.clear();
        OpenCharDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        OpenCharDoubleHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharDoubleHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        OpenCharDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenCharDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharDoubleHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        map.forEachPair(new CharDoubleProcedure(){

            public boolean apply(char first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharDoubleHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new CharDoubleProcedure(){
            int count = 0;

            public boolean apply(char first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        OpenCharDoubleHashMapTest.assertEquals((double)22.0, (double)map.get('\u000b'), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((double)0.0, (double)map.get('\u0000'), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.adjustOrPutValue('\u000b', 1.0, 3.0);
        OpenCharDoubleHashMapTest.assertEquals((double)25.0, (double)map.get('\u000b'), (double)1.0E-6);
        map.adjustOrPutValue('\u000f', 1.0, 3.0);
        OpenCharDoubleHashMapTest.assertEquals((double)1.0, (double)map.get('\u000f'), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 22.0);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        map.pairsMatching(new CharDoubleProcedure(){

            public boolean apply(char first, double second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharDoubleHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharDoubleHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenCharDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        OpenCharDoubleHashMap map2 = (OpenCharDoubleHashMap)map.copy();
        map.clear();
        OpenCharDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        OpenCharDoubleHashMap map2 = (OpenCharDoubleHashMap)map.copy();
        OpenCharDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 22.0);
        map.put('\f', 23.0);
        map.put('\r', 24.0);
        map.put('\u000e', 25.0);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharDoubleHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharDoubleHashMap map = new OpenCharDoubleHashMap();
        map.put('\u000b', 100.0);
        map.put('\f', 70.0);
        map.put('\r', 30.0);
        map.put('\u000e', 3.0);
        CharArrayList keys = new CharArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenCharDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        double v;

        Pair(char k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

