/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharObjectProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.OpenCharObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenCharObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass('e');
        this.anotherItem = new TestClass('c');
        this.anotherItem2 = new TestClass('\u0002');
        this.anotherItem3 = new TestClass('\u0003');
        this.anotherItem4 = new TestClass('\u0004');
        this.anotherItem5 = new TestClass('\u0005');
    }

    @Test
    public void testConstructors() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        for (int i = 0; i < 100; ++i) {
            map.put((char)i, (Object)this.item);
            OpenCharObjectHashMapTest.assertEquals((long)1L, (long)map.size());
            map.clear();
            OpenCharObjectHashMapTest.assertEquals((long)0L, (long)map.size());
            OpenCharObjectHashMapTest.assertFalse((String)("Contains: " + i), (boolean)map.containsKey((char)i));
            OpenCharObjectHashMapTest.assertSame(null, (Object)map.get((char)i));
        }
    }

    @Test
    public void testClone() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        OpenCharObjectHashMap map2 = map.clone();
        map.clear();
        OpenCharObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        OpenCharObjectHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharObjectHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        OpenCharObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenCharObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem);
        map.put('\f', (Object)this.anotherItem2);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem4);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharObjectHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem);
        map.put('\f', (Object)this.anotherItem2);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem4);
        map.removeKey('\r');
        map.forEachPair((CharObjectProcedure)new CharObjectProcedure<TestClass>(){

            public boolean apply(char first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharObjectHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenCharObjectHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenCharObjectHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((CharObjectProcedure)new CharObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(char first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        map.put('\f', (Object)this.anotherItem);
        OpenCharObjectHashMapTest.assertSame((Object)this.item, (Object)map.get('\u000b'));
        OpenCharObjectHashMapTest.assertSame(null, (Object)map.get('\u0000'));
    }

    @Test
    public void testKeys() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        map.put('\f', (Object)this.item);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        ArrayList valueList = new ArrayList();
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem2);
        map.put('\f', (Object)this.anotherItem3);
        map.put('\r', (Object)this.anotherItem4);
        map.put('\u000e', (Object)this.anotherItem5);
        map.removeKey('\r');
        map.pairsMatching((CharObjectProcedure)new CharObjectProcedure<TestClass>(){

            public boolean apply(char first, TestClass second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenCharObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharObjectHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharObjectHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem);
        map.put('\f', (Object)this.anotherItem2);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem4);
        map.removeKey('\r');
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenCharObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.item);
        OpenCharObjectHashMap map2 = (OpenCharObjectHashMap)map.copy();
        map.clear();
        OpenCharObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem);
        map.put('\f', (Object)this.anotherItem2);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem4);
        map.removeKey('\r');
        OpenCharObjectHashMap map2 = (OpenCharObjectHashMap)map.copy();
        OpenCharObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem5);
        map.put('\f', (Object)this.anotherItem4);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem2);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharObjectHashMapTest.assertArrayEquals((char[])new char[]{'\u000e', '\f', '\u000b'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem5);
        map.put('\f', (Object)this.anotherItem4);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem2);
        CharArrayList keys = new CharArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenCharObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenCharObjectHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenCharObjectHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenCharObjectHashMap map = new OpenCharObjectHashMap();
        map.put('\u000b', (Object)this.anotherItem5);
        map.put('\f', (Object)this.anotherItem4);
        map.put('\r', (Object)this.anotherItem3);
        map.put('\u000e', (Object)this.anotherItem2);
        CharArrayList keys = new CharArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenCharObjectHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenCharObjectHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenCharObjectHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenCharObjectHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        TestClass v;

        Pair(char k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        char x;

        TestClass(char x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Character.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return this.x - o.x;
        }
    }
}

