/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleDoubleProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenDoubleDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        OpenDoubleDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        OpenDoubleDoubleHashMap map2 = (OpenDoubleDoubleHashMap)map.clone();
        map.clear();
        OpenDoubleDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        OpenDoubleDoubleHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        OpenDoubleDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleDoubleHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        map.forEachPair(new DoubleDoubleProcedure(){

            public boolean apply(double first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleDoubleHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new DoubleDoubleProcedure(){
            int count = 0;

            public boolean apply(double first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        OpenDoubleDoubleHashMapTest.assertEquals((double)22.0, (double)map.get(11.0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(0.0), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.adjustOrPutValue(11.0, 1.0, 3.0);
        OpenDoubleDoubleHashMapTest.assertEquals((double)25.0, (double)map.get(11.0), (double)1.0E-6);
        map.adjustOrPutValue(15.0, 1.0, 3.0);
        OpenDoubleDoubleHashMapTest.assertEquals((double)1.0, (double)map.get(15.0), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 22.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleDoubleProcedure(){

            public boolean apply(double first, double second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleDoubleHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenDoubleDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        OpenDoubleDoubleHashMap map2 = (OpenDoubleDoubleHashMap)map.copy();
        map.clear();
        OpenDoubleDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        OpenDoubleDoubleHashMap map2 = (OpenDoubleDoubleHashMap)map.copy();
        OpenDoubleDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 22.0);
        map.put(12.0, 23.0);
        map.put(13.0, 24.0);
        map.put(14.0, 25.0);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleDoubleHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleDoubleHashMap map = new OpenDoubleDoubleHashMap();
        map.put(11.0, 100.0);
        map.put(12.0, 70.0);
        map.put(13.0, 30.0);
        map.put(14.0, 3.0);
        DoubleArrayList keys = new DoubleArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        double v;

        Pair(double k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

