/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntCharProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        OpenIntCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntCharHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        OpenIntCharHashMap map2 = (OpenIntCharHashMap)map.clone();
        map.clear();
        OpenIntCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        OpenIntCharHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntCharHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        OpenIntCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenIntCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntCharHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        map.forEachPair(new IntCharProcedure(){

            public boolean apply(int first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenIntCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenIntCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new IntCharProcedure(){
            int count = 0;

            public boolean apply(int first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        OpenIntCharHashMapTest.assertEquals((long)22L, (long)map.get(11));
        OpenIntCharHashMapTest.assertEquals((long)0L, (long)map.get(0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.adjustOrPutValue(11, '\u0001', '\u0003');
        OpenIntCharHashMapTest.assertEquals((long)25L, (long)map.get(11));
        map.adjustOrPutValue(15, '\u0001', '\u0003');
        OpenIntCharHashMapTest.assertEquals((long)1L, (long)map.get(15));
    }

    @Test
    public void testKeys() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0016');
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        map.pairsMatching(new IntCharProcedure(){

            public boolean apply(int first, char second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntCharHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntCharHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenIntCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenIntCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenIntCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenIntCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        OpenIntCharHashMap map2 = (OpenIntCharHashMap)map.copy();
        map.clear();
        OpenIntCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        OpenIntCharHashMap map2 = (OpenIntCharHashMap)map.copy();
        OpenIntCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, '\u0016');
        map.put(12, '\u0017');
        map.put(13, '\u0018');
        map.put(14, '\u0019');
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntCharHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntCharHashMap map = new OpenIntCharHashMap();
        map.put(11, 'd');
        map.put(12, 'F');
        map.put(13, '\u001e');
        map.put(14, '\u0003');
        IntArrayList keys = new IntArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenIntCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenIntCharHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenIntCharHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntCharHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenIntCharHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenIntCharHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenIntCharHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        char v;

        Pair(int k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

