/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntObjectProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenIntObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101);
        this.anotherItem = new TestClass(99);
        this.anotherItem2 = new TestClass(2);
        this.anotherItem3 = new TestClass(3);
        this.anotherItem4 = new TestClass(4);
        this.anotherItem5 = new TestClass(5);
    }

    @Test
    public void testConstructors() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        for (int i = 0; i < 100; ++i) {
            map.put(i, (Object)this.item);
            OpenIntObjectHashMapTest.assertEquals((long)1L, (long)map.size());
            map.clear();
            OpenIntObjectHashMapTest.assertEquals((long)0L, (long)map.size());
            OpenIntObjectHashMapTest.assertFalse((String)("Contains: " + i), (boolean)map.containsKey(i));
            OpenIntObjectHashMapTest.assertSame(null, (Object)map.get(i));
        }
    }

    @Test
    public void testClone() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        OpenIntObjectHashMap map2 = map.clone();
        map.clear();
        OpenIntObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        OpenIntObjectHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntObjectHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        OpenIntObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenIntObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem);
        map.put(12, (Object)this.anotherItem2);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem4);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntObjectHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem);
        map.put(12, (Object)this.anotherItem2);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem4);
        map.removeKey(13);
        map.forEachPair((IntObjectProcedure)new IntObjectProcedure<TestClass>(){

            public boolean apply(int first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntObjectHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenIntObjectHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenIntObjectHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((IntObjectProcedure)new IntObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(int first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        map.put(12, (Object)this.anotherItem);
        OpenIntObjectHashMapTest.assertSame((Object)this.item, (Object)map.get(11));
        OpenIntObjectHashMapTest.assertSame(null, (Object)map.get(0));
    }

    @Test
    public void testKeys() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        map.put(12, (Object)this.item);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        ArrayList valueList = new ArrayList();
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem2);
        map.put(12, (Object)this.anotherItem3);
        map.put(13, (Object)this.anotherItem4);
        map.put(14, (Object)this.anotherItem5);
        map.removeKey(13);
        map.pairsMatching((IntObjectProcedure)new IntObjectProcedure<TestClass>(){

            public boolean apply(int first, TestClass second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenIntObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntObjectHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntObjectHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem);
        map.put(12, (Object)this.anotherItem2);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem4);
        map.removeKey(13);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenIntObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.item);
        OpenIntObjectHashMap map2 = (OpenIntObjectHashMap)map.copy();
        map.clear();
        OpenIntObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem);
        map.put(12, (Object)this.anotherItem2);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem4);
        map.removeKey(13);
        OpenIntObjectHashMap map2 = (OpenIntObjectHashMap)map.copy();
        OpenIntObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem5);
        map.put(12, (Object)this.anotherItem4);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem2);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntObjectHashMapTest.assertArrayEquals((int[])new int[]{14, 12, 11}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem5);
        map.put(12, (Object)this.anotherItem4);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem2);
        IntArrayList keys = new IntArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenIntObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenIntObjectHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenIntObjectHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenIntObjectHashMap map = new OpenIntObjectHashMap();
        map.put(11, (Object)this.anotherItem5);
        map.put(12, (Object)this.anotherItem4);
        map.put(13, (Object)this.anotherItem3);
        map.put(14, (Object)this.anotherItem2);
        IntArrayList keys = new IntArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenIntObjectHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenIntObjectHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenIntObjectHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenIntObjectHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        TestClass v;

        Pair(int k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        int x;

        TestClass(int x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Integer.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return this.x - o.x;
        }
    }
}

