/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongCharProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        OpenLongCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongCharHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        OpenLongCharHashMap map2 = (OpenLongCharHashMap)map.clone();
        map.clear();
        OpenLongCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        OpenLongCharHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongCharHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        OpenLongCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenLongCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongCharHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        map.forEachPair(new LongCharProcedure(){

            public boolean apply(long first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenLongCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenLongCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new LongCharProcedure(){
            int count = 0;

            public boolean apply(long first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        OpenLongCharHashMapTest.assertEquals((long)22L, (long)map.get(11L));
        OpenLongCharHashMapTest.assertEquals((long)0L, (long)map.get(0L));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.adjustOrPutValue(11L, '\u0001', '\u0003');
        OpenLongCharHashMapTest.assertEquals((long)25L, (long)map.get(11L));
        map.adjustOrPutValue(15L, '\u0001', '\u0003');
        OpenLongCharHashMapTest.assertEquals((long)1L, (long)map.get(15L));
    }

    @Test
    public void testKeys() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0016');
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        map.pairsMatching(new LongCharProcedure(){

            public boolean apply(long first, char second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongCharHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongCharHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenLongCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenLongCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenLongCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenLongCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        OpenLongCharHashMap map2 = (OpenLongCharHashMap)map.copy();
        map.clear();
        OpenLongCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        OpenLongCharHashMap map2 = (OpenLongCharHashMap)map.copy();
        OpenLongCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, '\u0016');
        map.put(12L, '\u0017');
        map.put(13L, '\u0018');
        map.put(14L, '\u0019');
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongCharHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongCharHashMap map = new OpenLongCharHashMap();
        map.put(11L, 'd');
        map.put(12L, 'F');
        map.put(13L, '\u001e');
        map.put(14L, '\u0003');
        LongArrayList keys = new LongArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenLongCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenLongCharHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenLongCharHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongCharHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenLongCharHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenLongCharHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenLongCharHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        char v;

        Pair(long k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

