/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortCharProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        OpenShortCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortCharHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        OpenShortCharHashMap map2 = (OpenShortCharHashMap)map.clone();
        map.clear();
        OpenShortCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        OpenShortCharHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortCharHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        OpenShortCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenShortCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortCharHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        map.forEachPair(new ShortCharProcedure(){

            public boolean apply(short first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenShortCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenShortCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ShortCharProcedure(){
            int count = 0;

            public boolean apply(short first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        OpenShortCharHashMapTest.assertEquals((long)22L, (long)map.get((short)11));
        OpenShortCharHashMapTest.assertEquals((long)0L, (long)map.get((short)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.adjustOrPutValue((short)11, '\u0001', '\u0003');
        OpenShortCharHashMapTest.assertEquals((long)25L, (long)map.get((short)11));
        map.adjustOrPutValue((short)15, '\u0001', '\u0003');
        OpenShortCharHashMapTest.assertEquals((long)1L, (long)map.get((short)15));
    }

    @Test
    public void testKeys() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0016');
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        map.pairsMatching(new ShortCharProcedure(){

            public boolean apply(short first, char second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortCharHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortCharHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenShortCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenShortCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenShortCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenShortCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        OpenShortCharHashMap map2 = (OpenShortCharHashMap)map.copy();
        map.clear();
        OpenShortCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        OpenShortCharHashMap map2 = (OpenShortCharHashMap)map.copy();
        OpenShortCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, '\u0016');
        map.put((short)12, '\u0017');
        map.put((short)13, '\u0018');
        map.put((short)14, '\u0019');
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortCharHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortCharHashMap map = new OpenShortCharHashMap();
        map.put((short)11, 'd');
        map.put((short)12, 'F');
        map.put((short)13, '\u001e');
        map.put((short)14, '\u0003');
        ShortArrayList keys = new ShortArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenShortCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenShortCharHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenShortCharHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortCharHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenShortCharHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenShortCharHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenShortCharHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        char v;

        Pair(short k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

