/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomTrinaryMatrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.ssvd.SequentialBigSvd;
import org.junit.Test;

public final class SequentialBigSvdTest
extends MahoutTestCase {
    @Test
    public void testSingularValues() {
        Matrix A = SequentialBigSvdTest.lowRankMatrix();
        SequentialBigSvd s = new SequentialBigSvd(A, 8);
        SingularValueDecomposition svd = new SingularValueDecomposition(A);
        Vector reference = new DenseVector(svd.getSingularValues()).viewPart(0, 8);
        SequentialBigSvdTest.assertEquals(reference, s.getSingularValues());
        SequentialBigSvdTest.assertEquals(A, s.getU().times((Matrix)new DiagonalMatrix(s.getSingularValues())).times(s.getV().transpose()));
    }

    @Test
    public void testLeftVectors() {
        Matrix A = SequentialBigSvdTest.lowRankMatrix();
        SequentialBigSvd s = new SequentialBigSvd(A, 8);
        SingularValueDecomposition svd = new SingularValueDecomposition(A);
        Matrix u1 = svd.getU().viewPart(0, 20, 0, 4).assign(Functions.ABS);
        Matrix u2 = s.getU().viewPart(0, 20, 0, 4).assign(Functions.ABS);
        SequentialBigSvdTest.assertEquals((double)0.0, (double)u1.minus(u2).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-9);
    }

    private static void assertEquals(Matrix u1, Matrix u2) {
        SequentialBigSvdTest.assertEquals((double)0.0, (double)u1.minus(u2).aggregate(Functions.MAX, Functions.ABS), (double)1.0E-10);
    }

    private static void assertEquals(Vector u1, Vector u2) {
        SequentialBigSvdTest.assertEquals((double)0.0, (double)u1.minus(u2).aggregate(Functions.MAX, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testRightVectors() {
        Matrix A = SequentialBigSvdTest.lowRankMatrix();
        SequentialBigSvd s = new SequentialBigSvd(A, 6);
        SingularValueDecomposition svd = new SingularValueDecomposition(A);
        Matrix v1 = svd.getV().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        Matrix v2 = s.getV().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        SequentialBigSvdTest.assertEquals(v1, v2);
    }

    private static Matrix lowRankMatrix() {
        RandomTrinaryMatrix u = new RandomTrinaryMatrix(1, 20, 4, false);
        DiagonalMatrix d = new DiagonalMatrix(new double[]{5.0, 3.0, 1.0, 0.5});
        RandomTrinaryMatrix v = new RandomTrinaryMatrix(2, 23, 4, false);
        return u.times((Matrix)d).times(v.transpose());
    }
}

