/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public final class LogLikelihood {
    private LogLikelihood() {
    }

    public static double entropy(long ... elements) {
        long sum = 0L;
        double result = 0.0;
        for (long element : elements) {
            Preconditions.checkArgument((element >= 0L ? 1 : 0) != 0);
            result += LogLikelihood.xLogX(element);
            sum += element;
        }
        return LogLikelihood.xLogX(sum) - result;
    }

    private static double xLogX(long x) {
        return x == 0L ? 0.0 : (double)x * Math.log(x);
    }

    private static double entropy(long a, long b) {
        return LogLikelihood.xLogX(a + b) - LogLikelihood.xLogX(a) - LogLikelihood.xLogX(b);
    }

    private static double entropy(long a, long b, long c, long d) {
        return LogLikelihood.xLogX(a + b + c + d) - LogLikelihood.xLogX(a) - LogLikelihood.xLogX(b) - LogLikelihood.xLogX(c) - LogLikelihood.xLogX(d);
    }

    public static double logLikelihoodRatio(long k11, long k12, long k21, long k22) {
        Preconditions.checkArgument((k11 >= 0L && k12 >= 0L && k21 >= 0L && k22 >= 0L ? 1 : 0) != 0);
        double rowEntropy = LogLikelihood.entropy(k11 + k12, k21 + k22);
        double columnEntropy = LogLikelihood.entropy(k11 + k21, k12 + k22);
        double matrixEntropy = LogLikelihood.entropy(k11, k12, k21, k22);
        if (rowEntropy + columnEntropy < matrixEntropy) {
            return 0.0;
        }
        return 2.0 * (rowEntropy + columnEntropy - matrixEntropy);
    }

    public static double rootLogLikelihoodRatio(long k11, long k12, long k21, long k22) {
        double llr = LogLikelihood.logLikelihoodRatio(k11, k12, k21, k22);
        double sqrt = Math.sqrt(llr);
        if ((double)k11 / (double)(k11 + k12) < (double)k21 / (double)(k21 + k22)) {
            sqrt = -sqrt;
        }
        return sqrt;
    }

    public static <T> List<ScoredItem<T>> compareFrequencies(Multiset<T> a, Multiset<T> b, int maxReturn, double threshold) {
        int totalA = a.size();
        int totalB = b.size();
        Ordering byScoreAscending = new Ordering<ScoredItem<T>>(){

            public int compare(ScoredItem<T> tScoredItem, ScoredItem<T> tScoredItem1) {
                return Double.compare(tScoredItem.score, tScoredItem1.score);
            }
        };
        PriorityQueue<ScoredItem<T>> best = new PriorityQueue<ScoredItem<T>>(maxReturn + 1, byScoreAscending);
        for (Object t : a.elementSet()) {
            LogLikelihood.compareAndAdd(a, b, maxReturn, threshold, totalA, totalB, best, t);
        }
        if (threshold < 0.0) {
            for (Object t : b.elementSet()) {
                if (a.count(t) != 0) continue;
                LogLikelihood.compareAndAdd(a, b, maxReturn, threshold, totalA, totalB, best, t);
            }
        }
        ArrayList r = Lists.newArrayList(best);
        Collections.sort(r, byScoreAscending.reverse());
        return r;
    }

    private static <T> void compareAndAdd(Multiset<T> a, Multiset<T> b, int maxReturn, double threshold, int totalA, int totalB, Queue<ScoredItem<T>> best, T t) {
        int kB;
        int kA = a.count(t);
        double score = LogLikelihood.rootLogLikelihoodRatio(kA, totalA - kA, kB = b.count(t), totalB - kB);
        if (score >= threshold) {
            ScoredItem<T> x = new ScoredItem<T>(t, score);
            best.add(x);
            while (best.size() > maxReturn) {
                best.poll();
            }
        }
    }

    public static final class ScoredItem<T> {
        private final T item;
        private final double score;

        public ScoredItem(T item, double score) {
            this.item = item;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public T getItem() {
            return this.item;
        }
    }
}

