/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.junit.Test;

public final class InvertedRunningAverageTest
extends TasteTestCase {
    @Test
    public void testAverage() {
        FullRunningAverage avg = new FullRunningAverage();
        InvertedRunningAverage inverted = new InvertedRunningAverage((RunningAverage)avg);
        InvertedRunningAverageTest.assertEquals((long)0L, (long)inverted.getCount());
        avg.addDatum(1.0);
        InvertedRunningAverageTest.assertEquals((long)1L, (long)inverted.getCount());
        InvertedRunningAverageTest.assertEquals((double)-1.0, (double)inverted.getAverage(), (double)1.0E-6);
        avg.addDatum(2.0);
        InvertedRunningAverageTest.assertEquals((long)2L, (long)inverted.getCount());
        InvertedRunningAverageTest.assertEquals((double)-1.5, (double)inverted.getAverage(), (double)1.0E-6);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupported1() {
        InvertedRunningAverage inverted = new InvertedRunningAverage((RunningAverage)new FullRunningAverage());
        inverted.addDatum(1.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupported2() {
        InvertedRunningAverage inverted = new InvertedRunningAverage((RunningAverage)new FullRunningAverage());
        inverted.changeDatum(1.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupported3() {
        InvertedRunningAverage inverted = new InvertedRunningAverage((RunningAverage)new FullRunningAverage());
        inverted.removeDatum(1.0);
    }

    @Test
    public void testAverageAndStdDev() {
        FullRunningAverageAndStdDev avg = new FullRunningAverageAndStdDev();
        InvertedRunningAverageAndStdDev inverted = new InvertedRunningAverageAndStdDev((RunningAverageAndStdDev)avg);
        InvertedRunningAverageTest.assertEquals((long)0L, (long)inverted.getCount());
        avg.addDatum(1.0);
        InvertedRunningAverageTest.assertEquals((long)1L, (long)inverted.getCount());
        InvertedRunningAverageTest.assertEquals((double)-1.0, (double)inverted.getAverage(), (double)1.0E-6);
        avg.addDatum(2.0);
        InvertedRunningAverageTest.assertEquals((long)2L, (long)inverted.getCount());
        InvertedRunningAverageTest.assertEquals((double)-1.5, (double)inverted.getAverage(), (double)1.0E-6);
        InvertedRunningAverageTest.assertEquals((double)(Math.sqrt(2.0) / 2.0), (double)inverted.getStandardDeviation(), (double)1.0E-6);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAndStdDevUnsupported1() {
        InvertedRunningAverageAndStdDev inverted = new InvertedRunningAverageAndStdDev((RunningAverageAndStdDev)new FullRunningAverageAndStdDev());
        inverted.addDatum(1.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAndStdDevUnsupported2() {
        InvertedRunningAverageAndStdDev inverted = new InvertedRunningAverageAndStdDev((RunningAverageAndStdDev)new FullRunningAverageAndStdDev());
        inverted.changeDatum(1.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAndStdDevUnsupported3() {
        InvertedRunningAverageAndStdDev inverted = new InvertedRunningAverageAndStdDev((RunningAverageAndStdDev)new FullRunningAverageAndStdDev());
        inverted.removeDatum(1.0);
    }
}

