/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.junit.Test;

public final class SamplingLongPrimitiveIteratorTest
extends TasteTestCase {
    @Test
    public void testEmptyCase() {
        SamplingLongPrimitiveIteratorTest.assertFalse((boolean)new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(0), 0.9999).hasNext());
        SamplingLongPrimitiveIteratorTest.assertFalse((boolean)new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(0), 1.0).hasNext());
    }

    @Test
    public void testSmallInput() {
        SamplingLongPrimitiveIterator t = new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(1), 0.9999);
        SamplingLongPrimitiveIteratorTest.assertTrue((boolean)t.hasNext());
        SamplingLongPrimitiveIteratorTest.assertEquals((long)0L, (long)t.nextLong());
        SamplingLongPrimitiveIteratorTest.assertFalse((boolean)t.hasNext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadRate1() {
        new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(1), 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadRate2() {
        new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(1), 1.1);
    }

    @Test
    public void testExactSizeMatch() {
        SamplingLongPrimitiveIterator t = new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(10), 1.0);
        for (int i = 0; i < 10; ++i) {
            SamplingLongPrimitiveIteratorTest.assertTrue((boolean)t.hasNext());
            SamplingLongPrimitiveIteratorTest.assertEquals((long)i, (long)t.next().intValue());
        }
        SamplingLongPrimitiveIteratorTest.assertFalse((boolean)t.hasNext());
    }

    @Test
    public void testSample() {
        double p = 0.1;
        int n = 1000;
        double sd = Math.sqrt((double)n * p * (1.0 - p));
        for (int i = 0; i < 1000; ++i) {
            SamplingLongPrimitiveIterator t = new SamplingLongPrimitiveIterator((LongPrimitiveIterator)SamplingLongPrimitiveIteratorTest.countingIterator(n), p);
            int k = 0;
            while (t.hasNext()) {
                long v = t.nextLong();
                ++k;
                SamplingLongPrimitiveIteratorTest.assertTrue((v >= 0L ? 1 : 0) != 0);
                SamplingLongPrimitiveIteratorTest.assertTrue((v < 1000L ? 1 : 0) != 0);
            }
            SamplingLongPrimitiveIteratorTest.assertTrue(((double)k >= 100.0 - 5.0 * sd ? 1 : 0) != 0);
            SamplingLongPrimitiveIteratorTest.assertTrue(((double)k <= 100.0 + 5.0 * sd ? 1 : 0) != 0);
        }
    }

    private static LongPrimitiveArrayIterator countingIterator(int to) {
        long[] data = new long[to];
        for (int i = 0; i < to; ++i) {
            data[i] = i;
        }
        return new LongPrimitiveArrayIterator(data);
    }
}

