/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.Preference;
import org.junit.Test;

public final class GenericUserPreferenceArrayTest
extends TasteTestCase {
    @Test
    public void testUserID() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setUserID(0, 1L);
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(2));
    }

    @Test
    public void testItemID() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setItemID(0, 1L);
        prefs.setItemID(1, 2L);
        prefs.setItemID(2, 3L);
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(1));
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(2));
    }

    @Test
    public void testSetValue() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setValue(0, 1.0f);
        prefs.setValue(1, 2.0f);
        prefs.setValue(2, 3.0f);
        GenericUserPreferenceArrayTest.assertEquals((double)1.0, (double)prefs.getValue(0), (double)1.0E-6);
        GenericUserPreferenceArrayTest.assertEquals((double)2.0, (double)prefs.getValue(1), (double)1.0E-6);
        GenericUserPreferenceArrayTest.assertEquals((double)3.0, (double)prefs.getValue(2), (double)1.0E-6);
    }

    @Test
    public void testHasPref() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        GenericUserPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithItemID(3L));
        GenericUserPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithUserID(1L));
        GenericUserPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithItemID(2L));
        GenericUserPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithUserID(2L));
    }

    @Test
    public void testSort() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 5.0f));
        prefs.set(2, (Preference)new GenericPreference(1L, 2L, 5.0f));
        prefs.sortByItem();
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(1));
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(2));
    }

    @Test
    public void testSortValue() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 4.0f));
        prefs.set(2, (Preference)new GenericPreference(1L, 2L, 3.0f));
        prefs.sortByValue();
        GenericUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(2));
        prefs.sortByValueReversed();
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
        GenericUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(2));
    }

    @Test
    public void testClone() {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 4.0f));
        prefs.set(2, (Preference)new GenericPreference(1L, 2L, 3.0f));
        prefs = prefs.clone();
        GenericUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(0));
        GenericUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
        GenericUserPreferenceArrayTest.assertEquals((double)3.0, (double)prefs.getValue(2), (double)1.0E-6);
    }
}

