/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.PlusAnonymousConcurrentUserDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public final class PlusAnonymousConcurrentUserDataModelTest
extends MahoutTestCase {
    private static PlusAnonymousConcurrentUserDataModel getTestableWithoutDelegateData(int maxConcurrentUsers) {
        FastByIDMap delegatePreferences = new FastByIDMap();
        return new PlusAnonymousConcurrentUserDataModel((DataModel)new GenericDataModel(delegatePreferences), maxConcurrentUsers);
    }

    private static PlusAnonymousConcurrentUserDataModel getTestableWithDelegateData(int maxConcurrentUsers, FastByIDMap<PreferenceArray> delegatePreferences) {
        return new PlusAnonymousConcurrentUserDataModel((DataModel)new GenericDataModel(delegatePreferences), maxConcurrentUsers);
    }

    @Test
    public void testTakeFirstAvailableUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long expResult = Long.MIN_VALUE;
        Long result = instance.takeAvailableUser();
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testTakeNextAvailableUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        instance.takeAvailableUser();
        Long result = instance.takeAvailableUser();
        Long expResult = -9223372036854775807L;
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testTakeUnavailableUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(1);
        instance.takeAvailableUser();
        PlusAnonymousConcurrentUserDataModelTest.assertNull((Object)instance.takeAvailableUser());
    }

    @Test
    public void testReleaseValidUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long takenUserID = instance.takeAvailableUser();
        PlusAnonymousConcurrentUserDataModelTest.assertTrue((boolean)instance.releaseUser(takenUserID));
    }

    @Test
    public void testReleaseInvalidUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        PlusAnonymousConcurrentUserDataModelTest.assertFalse((boolean)instance.releaseUser(Long.valueOf(Long.MAX_VALUE)));
    }

    @Test
    public void testReleasePreviouslyReleasedUser() {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long takenUserID = instance.takeAvailableUser();
        PlusAnonymousConcurrentUserDataModelTest.assertTrue((boolean)instance.releaseUser(takenUserID));
        PlusAnonymousConcurrentUserDataModelTest.assertFalse((boolean)instance.releaseUser(takenUserID));
    }

    @Test
    public void testSetAndGetTempPreferences() throws TasteException {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long anonymousUserID = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs = new GenericUserPreferenceArray(1);
        tempPrefs.setUserID(0, anonymousUserID.longValue());
        tempPrefs.setItemID(0, 1L);
        instance.setTempPrefs((PreferenceArray)tempPrefs, anonymousUserID.longValue());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)tempPrefs, (Object)instance.getPreferencesFromUser(anonymousUserID.longValue()));
        instance.releaseUser(anonymousUserID);
    }

    @Test
    public void testSetMultipleTempPreferences() throws TasteException {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long anonymousUserID1 = instance.takeAvailableUser();
        Long anonymousUserID2 = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs1 = new GenericUserPreferenceArray(1);
        tempPrefs1.setUserID(0, anonymousUserID1.longValue());
        tempPrefs1.setItemID(0, 1L);
        GenericUserPreferenceArray tempPrefs2 = new GenericUserPreferenceArray(2);
        tempPrefs2.setUserID(0, anonymousUserID2.longValue());
        tempPrefs2.setItemID(0, 2L);
        tempPrefs2.setUserID(1, anonymousUserID2.longValue());
        tempPrefs2.setItemID(1, 3L);
        instance.setTempPrefs((PreferenceArray)tempPrefs1, anonymousUserID1.longValue());
        instance.setTempPrefs((PreferenceArray)tempPrefs2, anonymousUserID2.longValue());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)tempPrefs1, (Object)instance.getPreferencesFromUser(anonymousUserID1.longValue()));
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)tempPrefs2, (Object)instance.getPreferencesFromUser(anonymousUserID2.longValue()));
    }

    @Test
    public void testGetNumUsersWithDelegateUsersOnly() throws TasteException {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(1);
        long sampleUserID = 1L;
        prefs.setUserID(0, sampleUserID);
        long sampleItemID = 11L;
        prefs.setItemID(0, sampleItemID);
        FastByIDMap delegatePreferences = new FastByIDMap();
        delegatePreferences.put(sampleUserID, (Object)prefs);
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithDelegateData(10, (FastByIDMap<PreferenceArray>)delegatePreferences);
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)1L, (long)instance.getNumUsers());
    }

    @Test
    public void testGetNumAnonymousUsers() throws TasteException {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long anonymousUserID1 = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs1 = new GenericUserPreferenceArray(1);
        tempPrefs1.setUserID(0, anonymousUserID1.longValue());
        tempPrefs1.setItemID(0, 1L);
        instance.setTempPrefs((PreferenceArray)tempPrefs1, anonymousUserID1.longValue());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)0L, (long)instance.getNumUsers());
    }

    @Test
    public void testGetPreferenceValue() throws TasteException {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        Long anonymousUserID = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs = new GenericUserPreferenceArray(1);
        tempPrefs.setUserID(0, anonymousUserID.longValue());
        long sampleItemID = 1L;
        tempPrefs.setItemID(0, sampleItemID);
        tempPrefs.setValue(0, Float.MAX_VALUE);
        instance.setTempPrefs((PreferenceArray)tempPrefs, anonymousUserID.longValue());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((double)3.4028234663852886E38, (double)instance.getPreferenceValue(anonymousUserID.longValue(), sampleItemID).floatValue(), (double)1.0E-6);
    }

    @Test
    public void testGetPreferencesForNonAnonymousUser() throws TasteException {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(1);
        long sampleUserID = 1L;
        prefs.setUserID(0, sampleUserID);
        long sampleItemID = 11L;
        prefs.setItemID(0, sampleItemID);
        FastByIDMap delegatePreferences = new FastByIDMap();
        delegatePreferences.put(sampleUserID, (Object)prefs);
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithDelegateData(10, (FastByIDMap<PreferenceArray>)delegatePreferences);
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((Object)prefs, (Object)instance.getPreferencesFromUser(sampleUserID));
    }

    @Test(expected=NoSuchUserException.class)
    public void testGetPreferencesForNonExistingUser() throws TasteException {
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithoutDelegateData(10);
        instance.getPreferencesFromUser(1L);
    }

    @Test
    public void testGetUserIDs() throws TasteException {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(1);
        long sampleUserID = 1L;
        prefs.setUserID(0, sampleUserID);
        long sampleItemID = 11L;
        prefs.setItemID(0, sampleItemID);
        FastByIDMap delegatePreferences = new FastByIDMap();
        delegatePreferences.put(sampleUserID, (Object)prefs);
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithDelegateData(10, (FastByIDMap<PreferenceArray>)delegatePreferences);
        Long anonymousUserID = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs = new GenericUserPreferenceArray(1);
        tempPrefs.setUserID(0, anonymousUserID.longValue());
        tempPrefs.setItemID(0, 22L);
        instance.setTempPrefs((PreferenceArray)tempPrefs, anonymousUserID.longValue());
        LongPrimitiveIterator userIDs = instance.getUserIDs();
        PlusAnonymousConcurrentUserDataModelTest.assertSame((Object)sampleUserID, userIDs.next());
        PlusAnonymousConcurrentUserDataModelTest.assertFalse((boolean)userIDs.hasNext());
    }

    @Test
    public void testGetPreferencesForItem() throws TasteException {
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(2);
        long sampleUserID = 4L;
        prefs.setUserID(0, sampleUserID);
        long sampleItemID = 11L;
        prefs.setItemID(0, sampleItemID);
        prefs.setUserID(1, sampleUserID);
        long sampleItemID2 = 22L;
        prefs.setItemID(1, sampleItemID2);
        FastByIDMap delegatePreferences = new FastByIDMap();
        delegatePreferences.put(sampleUserID, (Object)prefs);
        PlusAnonymousConcurrentUserDataModel instance = PlusAnonymousConcurrentUserDataModelTest.getTestableWithDelegateData(10, (FastByIDMap<PreferenceArray>)delegatePreferences);
        Long anonymousUserID = instance.takeAvailableUser();
        GenericUserPreferenceArray tempPrefs = new GenericUserPreferenceArray(2);
        tempPrefs.setUserID(0, anonymousUserID.longValue());
        tempPrefs.setItemID(0, sampleItemID);
        tempPrefs.setUserID(1, anonymousUserID.longValue());
        long sampleItemID3 = 33L;
        tempPrefs.setItemID(1, sampleItemID3);
        instance.setTempPrefs((PreferenceArray)tempPrefs, anonymousUserID.longValue());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)sampleUserID, (long)instance.getPreferencesForItem(sampleItemID).get(0).getUserID());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)2L, (long)instance.getPreferencesForItem(sampleItemID).length());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)1L, (long)instance.getPreferencesForItem(sampleItemID2).length());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)1L, (long)instance.getPreferencesForItem(sampleItemID3).length());
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)2L, (long)instance.getNumUsersWithPreferenceFor(sampleItemID));
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)1L, (long)instance.getNumUsersWithPreferenceFor(sampleItemID, sampleItemID2));
        PlusAnonymousConcurrentUserDataModelTest.assertEquals((long)1L, (long)instance.getNumUsersWithPreferenceFor(sampleItemID, sampleItemID3));
    }
}

