/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.file;

import java.io.File;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.file.FileItemItemSimilarityIterable;
import org.apache.mahout.cf.taste.impl.similarity.file.FileItemSimilarity;
import org.junit.Before;
import org.junit.Test;

public final class FileItemSimilarityTest
extends TasteTestCase {
    private static final String[] data = new String[]{"1,5,0.125", "1,7,0.5"};
    private static final String[] changedData = new String[]{"1,5,0.125", "1,7,0.9", "7,8,0.112"};
    private File testFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.testFile = this.getTestTempFile("test.txt");
        FileItemSimilarityTest.writeLines(this.testFile, data);
    }

    @Test
    public void testLoadFromFile() throws Exception {
        FileItemSimilarity similarity = new FileItemSimilarity(this.testFile);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(1L, 5L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(5L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(1L, 7L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(7L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertTrue((boolean)Double.isNaN(similarity.itemSimilarity(7L, 8L)));
        double[] valuesForOne = similarity.itemSimilarities(1L, new long[]{5L, 7L});
        FileItemSimilarityTest.assertNotNull((Object)valuesForOne);
        FileItemSimilarityTest.assertEquals((long)2L, (long)valuesForOne.length);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)valuesForOne[0], (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)valuesForOne[1], (double)1.0E-6);
    }

    @Test
    public void testNoRefreshAfterFileUpdate() throws Exception {
        FileItemSimilarity similarity = new FileItemSimilarity(this.testFile, 0L);
        similarity.itemSimilarity(1L, 5L);
        Thread.sleep(2000L);
        FileItemSimilarityTest.writeLines(this.testFile, changedData);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(1L, 7L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(7L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertTrue((boolean)Double.isNaN(similarity.itemSimilarity(7L, 8L)));
    }

    @Test
    public void testRefreshAfterFileUpdate() throws Exception {
        FileItemSimilarity similarity = new FileItemSimilarity(this.testFile, 0L);
        similarity.itemSimilarity(1L, 5L);
        Thread.sleep(2000L);
        FileItemSimilarityTest.writeLines(this.testFile, changedData);
        similarity.refresh(null);
        FileItemSimilarityTest.assertEquals((double)0.9, (double)similarity.itemSimilarity(1L, 7L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.9, (double)similarity.itemSimilarity(7L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(1L, 5L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(5L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertFalse((boolean)Double.isNaN(similarity.itemSimilarity(7L, 8L)));
        FileItemSimilarityTest.assertEquals((double)0.112, (double)similarity.itemSimilarity(7L, 8L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.112, (double)similarity.itemSimilarity(8L, 7L), (double)1.0E-6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFileNotFoundExceptionForNonExistingFile() throws Exception {
        new FileItemSimilarity(new File("xKsdfksdfsdf"));
    }

    @Test
    public void testFileItemItemSimilarityIterable() throws Exception {
        FileItemItemSimilarityIterable similarityIterable = new FileItemItemSimilarityIterable(this.testFile);
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarityIterable);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(1L, 5L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)similarity.itemSimilarity(5L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(1L, 7L), (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)similarity.itemSimilarity(7L, 1L), (double)1.0E-6);
        FileItemSimilarityTest.assertTrue((boolean)Double.isNaN(similarity.itemSimilarity(7L, 8L)));
        double[] valuesForOne = similarity.itemSimilarities(1L, new long[]{5L, 7L});
        FileItemSimilarityTest.assertNotNull((Object)valuesForOne);
        FileItemSimilarityTest.assertEquals((long)2L, (long)valuesForOne.length);
        FileItemSimilarityTest.assertEquals((double)0.125, (double)valuesForOne[0], (double)1.0E-6);
        FileItemSimilarityTest.assertEquals((double)0.5, (double)valuesForOne[1], (double)1.0E-6);
    }

    @Test
    public void testToString() throws Exception {
        FileItemSimilarity similarity = new FileItemSimilarity(this.testFile);
        FileItemSimilarityTest.assertTrue((!similarity.toString().isEmpty() ? 1 : 0) != 0);
    }
}

