/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.partial;

import java.util.Random;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Utils;
import org.apache.mahout.classifier.df.mapreduce.partial.Step1Mapper;
import org.apache.mahout.classifier.df.mapreduce.partial.TreeID;
import org.apache.mahout.classifier.df.node.Leaf;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public final class Step1MapperTest
extends MahoutTestCase {
    static final int NUM_ATTRIBUTES = 4;
    static final int NUM_INSTANCES = 100;
    static final int NUM_TREES = 10;
    static final int NUM_MAPPERS = 2;

    @Test
    public void testMapper() throws Exception {
        RandomWrapper rng = RandomUtils.getRandom();
        String descriptor = Utils.randomDescriptor((Random)rng, 4);
        double[][] source = Utils.randomDoubles((Random)rng, descriptor, false, 100);
        String[] sData = Utils.double2String(source);
        Dataset dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        String[][] splits = Utils.splitData(sData, 2);
        MockTreeBuilder treeBuilder = new MockTreeBuilder();
        LongWritable key = new LongWritable();
        Text value = new Text();
        int treeIndex = 0;
        for (int partition = 0; partition < 2; ++partition) {
            String[] split = splits[partition];
            treeBuilder.setExpected(DataLoader.loadData((Dataset)dataset, (String[])split));
            int mapNbTrees = Step1Mapper.nbTrees((int)2, (int)10, (int)partition);
            Mapper.Context context = (Mapper.Context)EasyMock.createNiceMock(Mapper.Context.class);
            TreeIDCapture capturedKeys = new TreeIDCapture();
            context.write(EasyMock.capture((Capture)capturedKeys), EasyMock.anyObject());
            EasyMock.expectLastCall().anyTimes();
            EasyMock.replay((Object[])new Object[]{context});
            MockStep1Mapper mapper = new MockStep1Mapper(treeBuilder, dataset, null, partition, 2, 10);
            Step1MapperTest.assertEquals((long)treeIndex, (long)mapper.getFirstTreeId());
            for (int index = 0; index < split.length; ++index) {
                key.set((long)index);
                value.set(split[index]);
                mapper.map(key, value, context);
            }
            mapper.cleanup(context);
            EasyMock.verify((Object[])new Object[]{context});
            Step1MapperTest.assertEquals((long)mapNbTrees, (long)capturedKeys.getValues().size());
            for (TreeID k : capturedKeys.getValues()) {
                Step1MapperTest.assertEquals((long)partition, (long)k.partition());
                Step1MapperTest.assertEquals((long)treeIndex, (long)k.treeId());
                ++treeIndex;
            }
        }
    }

    private static class TreeIDCapture
    extends Capture<TreeID> {
        private TreeIDCapture() {
            super(CaptureType.ALL);
        }

        public void setValue(TreeID value) {
            super.setValue((Object)value.clone());
        }
    }

    private static class MockStep1Mapper
    extends Step1Mapper {
        private MockStep1Mapper(TreeBuilder treeBuilder, Dataset dataset, Long seed, int partition, int numMapTasks, int numTrees) {
            this.configure(false, treeBuilder, dataset);
            this.configure(seed, partition, numMapTasks, numTrees);
        }
    }

    private static class MockTreeBuilder
    implements TreeBuilder {
        private Data expected;

        private MockTreeBuilder() {
        }

        public void setExpected(Data data) {
            this.expected = data;
        }

        public Node build(Random rng, Data data) {
            for (int index = 0; index < data.size(); ++index) {
                Assert.assertTrue((boolean)this.expected.contains(data.get(index)));
            }
            return new Leaf(Double.NaN);
        }
    }
}

